<?php
/**
 * Class Display. Conditions for item display
 *
 * @package     Wow_Plugin
 * @subpackage  Public
 * @author      Wow-Company <yoda@wow-company.com>
 * @copyright   2019 Wow-Company
 * @license     GNU Public License
 */

namespace side_menu_pro;

defined( 'ABSPATH' ) || exit;

class Display_Item {

	/**
	 * @var Conditions
	 */
	private $conditions;

	public function __construct( $info ) {
		$this->plugin = $info;

		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_scripts' ] );
		add_action( 'wp_footer', [ $this, 'wp_footer' ] );
		$this->conditions = new Conditions( $this->plugin );
	}

	public function wp_footer() {
		$result = $this->check();

		if ( ! empty( $result ) ) {
			foreach ( $result as $id => $param ) {
				$this->go_shortcode( $id );
			}
		}
	}

	public function enqueue_scripts() {
		$result = $this->check();

		if ( ! empty( $result ) ) {
			foreach ( $result as $id => $param ) {
				do_action( $this->plugin['slug'] . '_include_fontawesome', $param );
				do_action( $this->plugin['slug'] . '_include_style', $param );
			}
		}
	}


	public function get_table_result() {
		global $wpdb;
		$table  = $wpdb->prefix . "wow_" . $this->plugin['prefix'];
		$result = $wpdb->get_results( "SELECT * FROM $table ORDER BY id ASC" );

		return ! empty( $result ) ? $result : false;
	}

	public function check() {
		$data   = $this->get_table_result();
		$result = [];

		if ( $data ) {
			foreach ( $data as $key => $val ) {
				$param = unserialize( $val->param );

				if ( empty( $param['menu_1']['item_type'] ) || ! $this->conditions->check( $param ) ) {
					continue;
				}

				$display = ! empty( $param['show'] ) ? $param['show'] : 'all';
				$id      = $val->id;

				switch ( $display ) {
					case 'all':
					case 'homepage':
					case 'searchpage':
					case 'archivepage':
					case 'error_page':
					case 'posts_page':
						if ( $display === 'all' || ( $display === 'homepage' && is_front_page() ) || ( $display === 'searchpage' && is_search() ) || ( $display === 'archivepage' && is_archive() ) || ( $display === 'error_page' && is_404() ) || ( $display === 'posts_page' && is_home() ) ) {
							$result[ $id ] = $param;
						}
						break;
					case 'onlypost':
					case 'onlypage':
					case 'posts':
					case 'postsincat':
					case 'pages':
					case 'expost':
					case 'expage':
					case 'taxonomy':
					case 'post_type':
						$check_display = call_user_func( [ $this, 'display_' . $display ], $id, $param );
						if ( $check_display !== false ) {
							$result[ $id ] = $param;
						}
						break;
				}
			}
		}

		return $result;
	}

	private function display_onlypost( $id, $param ) {
		return is_single();
	}

	private function display_onlypage( $id, $param ) {
		return is_page();
	}

	private function display_posts( $id, $param ) {
		return ! empty( $param['id_post'] ) && is_single( explode( ',', $param['id_post'] ) );
	}

	private function display_postsincat( $id, $param ) {
		if ( in_category( explode( ',', $param['id_post'] ) ) ) {
			return true;
		}

		return false;
	}

	private function display_pages( $id, $param ) {
		$pages = preg_split( "/[,]+/", $param['id_post'] );
		$pages_arr = map_deep($pages, 'trim');
		if ( is_page( $pages_arr ) ) {
			return true;
		}

		return false;
	}

	private function display_expost( $id, $param ) {
		if ( ! is_single( explode( ',', $param['id_post'] ) ) ) {
			return true;
		}

		return false;
	}

	private function display_expage( $id, $param ) {
		$pages = preg_split( "/[,]+/", $param['id_post'] );
		$pages_arr = map_deep($pages, 'trim');
		if ( ! is_page( $pages_arr ) ) {
			return true;
		}

		return false;
	}

	private function display_taxonomy( $id, $param ) {
		$id_post  = str_replace( ' ', '', $param['id_post'] );
		$taxonomy = $param['taxonomy'];
		$terms    = preg_split( "/[,]+/", $id_post );

		if ( has_term( $terms, $taxonomy ) ) {
			return true;
		}

		return false;
	}

	public function display_post_type( $id, $param ) {
		return is_single() && get_post_type() === $param['post_types'];
	}

	public function go_shortcode( $id ) {
		echo do_shortcode( '[' . esc_attr( $this->plugin['shortcode'] ) . ' id=' . absint( $id ) . ']' );
	}

}