<?php
/**
 * Class Conditions. Check all Conditions
 *
 * @package     Wow_Plugin
 * @subpackage  Public
 * @author      Wow-Company <yoda@wow-company.com>
 * @copyright   2019 Wow-Company
 * @license     GNU Public License
 */

namespace side_menu_pro;

use DateTime;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Conditions {

	/**
	 * @var array
	 */
	public $info;

	public function __construct( $info ) {
		$this->plugin = $info;
	}

	public function check( $param ) {
		$check     = true;
		$check_arr = array(
			'license'   => $this->check_license(),
			'status'    => $this->check_status( $param ),
			'test_mode' => $this->check_test_mode( $param ),
			'user'      => $this->check_user( $param ),
			'language'  => $this->check_language( $param ),
			'browser'   => $this->check_browser( $param ),
			'day'       => $this->check_day( $param ),
			'date'      => $this->check_date( $param ),
		);

		foreach ( $check_arr as $value ) {
			if ( $value === false ) {
				$check = false;
				break;
			}
		}

		return $check;
	}

	private function check_license() {
		$license = get_option( 'wow_license_key_' . $this->plugin['prefix'] );
		$status  = get_option( 'wow_license_status_' . $this->plugin['prefix'] );
		if ( empty( $license ) || $status !== 'valid' ) {
			return false;
		}

		return true;
	}

	private function check_status( $param ) {
		if ( ! empty( $param['status'] ) ) {
			return false;
		}

		return true;
	}

	private function check_test_mode( $param ) {
		if ( ! empty( $param['test_mode'] ) && ! current_user_can( 'administrator' ) ) {
			return false;
		}

		return true;
	}

	private function check_user( $param ) {
		$user = isset( $param['item_user'] ) ? $param['item_user'] : 1;

		$users = [];

		if ( isset( $param['user_role'] ) ) {
			if ( is_array( $param['user_role'] ) ) {
				foreach ( $param['user_role'] as $key => $value ) {
					if ( empty( $value ) ) {
						continue;
					}
					$users[] = $key;
				}
			} else {
				$users[] = $param['user_role'];
			}
		}

		if ( $user == 3 ) {
			return ! is_user_logged_in();
		} elseif ( $user == 2 ) {
			if ( ! is_user_logged_in() ) {
				return false;
			}

			if ( in_array( 'all', $users ) ) {
				return true;
			}

			$current_user = wp_get_current_user();

			foreach ( $current_user->roles as $value ) {
				if ( in_array( $value, $users ) ) {
					return true;
				}
			}

			return false;
		}

		return true;
	}

	private function check_language( $param ) {
		if ( ! empty( $param['depending_language'] ) ) {
			$item_lang = $param['lang'];
			$site_lang = get_locale();
			if ( substr( $site_lang, 0, 2 ) != $item_lang ) {
				return false;
			}
		}

		return true;
	}

	private function check_browser( $param ) {
		$check = true;
		if ( ! empty( $param['all_browser'] ) ) {
			$browser = $this->get_browser_name();
			switch ( $browser ) {
				case 'Opera':
					$check = ! empty( $param['br_opera'] ) ? false : true;
					break;
				case 'Edge':
					$check = ! empty( $param['br_edge'] ) ? false : true;
					break;
				case 'Chrome':
					$check = ! empty( $param['br_chrome'] ) ? false : true;
					break;
				case 'Safari':
					$check = ! empty( $param['br_safari'] ) ? false : true;
					break;
				case 'Firefox':
					$check = ! empty( $param['br_firefox'] ) ? false : true;
					break;
				case 'IE':
					$check = ! empty( $param['br_ie'] ) ? false : true;
					break;
				case 'Other':
					$check = ! empty( $param['br_other'] ) ? false : true;
					break;
				default:
					$check = true;
			}
		}

		return $check;
	}

	private function get_browser_name() {
		$user_agent = $_SERVER['HTTP_USER_AGENT'];
		if ( strpos( $user_agent, 'Opera' ) || strpos( $user_agent, 'OPR/' ) ) {
			return 'Opera';
		} elseif ( strpos( $user_agent, 'Edg' ) ) {
			return 'Edge';
		} elseif ( strpos( $user_agent, 'Chrome' ) ) {
			return 'Chrome';
		} elseif ( strpos( $user_agent, 'Safari' ) ) {
			return 'Safari';
		} elseif ( strpos( $user_agent, 'Firefox' ) ) {
			return 'Firefox';
		} elseif ( strpos( $user_agent, 'MSIE' ) || strpos( $user_agent, 'Trident/7' ) ) {
			return 'IE';
		}

		return 'Other';
	}

	private function check_day( $param ) {
		$days       = isset( $param['weekday_arr'] ) ? $param['weekday_arr'] : [];
		$days[]     = isset( $param['weekday'] ) ? $param['weekday'] : 'none';
		$currentDay = date( 'N' );

		foreach ( $days as $key => $day ) {
			if ( $currentDay === $day || $day === 'none' ) {
				return $this->check_time( $key, $param );
			}
		}

		return false;
	}

	private function check_time( $key, $param ) {
		$starts   = isset( $param['time_start_arr'] ) ? $param['time_start_arr'] : [];
		$starts[] = isset( $param['time_start'] ) ? $param['time_start'] : '00:00';

		$ends   = isset( $param['time_end_arr'] ) ? $param['time_end_arr'] : [];
		$ends[] = isset( $param['time_end'] ) ? $param['time_end'] : '23:59';

		$start   = (float) str_replace( ':', '.', $starts[ $key ] );
		$end     = (float) str_replace( ':', '.', $ends[ $key ] );
		$current = (float) current_time( 'H.i' );

		return $start <= $current && $current <= $end;
	}

	private function check_date( $param ) {
		$date = true;
		if ( ! empty( $param['set_dates'] ) ) {
			$current = date( 'Y-m-d' );
			$start   = $param['date_start'];
			$end     = $param['date_end'];
			if ( $start <= $current && $current <= $end ) {
				$date = true;
			} else {
				$date = false;
			}
		}

		return $date;
	}

}