<?php
/**
 * Settings
 *
 * @package     Wow_Plugin
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */


$count_i = ( ! empty( $param['menu_1']['item_type'] ) ) ? count( $param['menu_1']['item_type'] ) : '0';
if ( $count_i > 0 ) {
	for ( $i = 0; $i < $count_i; $i ++ ) {
		// Icon
		$item_icon_[ $i ] = array(
			'name'   => 'param[menu_1][item_icon][]',
			'class'  => 'icons',
			'type'   => 'select',
			'val'    => isset( $param['menu_1']['item_icon'][ $i ] ) ? $param['menu_1']['item_icon'][ $i ]
				: 'fas fa-hand-point-up',
			'option' => $icons_new,
		);

		// Icon Animation
		$item_icon_anomate_[ $i ] = array(
			'name'   => 'param[menu_1][item_icon_anomate][]',
			'type'   => 'select',
			'val'    => isset( $param['menu_1']['item_icon_anomate'][ $i ] ) ? $param['menu_1']['item_icon_anomate'][ $i ]
				: '',
			'option' => [
				''             => __( 'None', 'side-menu' ),
				'fa-beat'      => __( 'Beat', 'side-menu' ),
				'fa-fade'      => __( 'Fade', 'side-menu' ),
				'fa-beat-fade' => __( 'Beat-Fade', 'side-menu' ),
				'fa-bounce'    => __( 'Bounce', 'side-menu' ),
				'fa-flip'      => __( 'Flip', 'side-menu' ),
				'fa-shake'     => __( 'Shake', 'side-menu' ),
				'fa-spin'      => __( 'Spin', 'side-menu' ),
			],
		);

		// Select custom icon
		$item_custom_[ $i ] = array(
			'name'  => 'param[menu_1][item_custom][]',
			'type'  => 'checkbox',
			'class' => 'custom-icon',
			'val'   => isset( $param['menu_1']['item_custom'][ $i ] ) ? $param['menu_1']['item_custom'][ $i ] : 0,
			'func'  => 'customicon(this);',
		);

		// Custom icon URL
		$item_custom_link_[ $i ] = array(
			'name'   => 'param[menu_1][item_custom_link][]',
			'type'   => 'text',
			'class'  => 'custom-icon-url',
			'val'    => isset( $param['menu_1']['item_custom_link'][ $i ] ) ? $param['menu_1']['item_custom_link'][ $i ]
				: '',
			'option' => array(
				'placeholder' => esc_attr__( 'Enter Icon URL', 'side-menu' ),
			),
		);

		$image_alt_[ $i ] = array(
			'name' => 'param[menu_1][image_alt][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['image_alt'][ $i ] ) ? $param['menu_1']['image_alt'][ $i ] : '',
		);

		// Select custom icon
		$item_custom_text_check_[ $i ] = array(
			'name'  => 'param[menu_1][item_custom_text_check][]',
			'type'  => 'checkbox',
			'class' => 'custom-icon-text',
			'val'   => isset( $param['menu_1']['item_custom_text_check'][ $i ] ) ? $param['menu_1']['item_custom_text_check'][ $i ] : 0,
		);

		// Custom icon URL
		$item_custom_text_[ $i ] = array(
			'name'  => 'param[menu_1][item_custom_text][]',
			'type'  => 'text',
			'val'   => isset( $param['menu_1']['item_custom_text'][ $i ] ) ? $param['menu_1']['item_custom_text'][ $i ]
				: '',
			'class' => 'icon-custom-text',

		);

		$item_icon_class_check_[ $i ] = array(
			'name'  => 'param[menu_1][item_icon_class_check][]',
			'type'  => 'checkbox',
			'val'   => isset( $param['menu_1']['item_icon_class_check'][ $i ] ) ? $param['menu_1']['item_icon_class_check'][ $i ]
				: '',
			'class' => 'item-icon-class-check',

		);

		$item_icon_class_[ $i ] = array(
			'name'  => 'param[menu_1][item_icon_class][]',
			'type'  => 'text',
			'val'   => isset( $param['menu_1']['item_icon_class'][ $i ] ) ? $param['menu_1']['item_icon_class'][ $i ]
				: '',
			'class' => 'item-icon-class',

		);

		// Label for item
		$item_tooltip_[ $i ] = array(
			'name'  => 'param[menu_1][item_tooltip][]',
			'class' => 'item-tooltip',
			'type'  => 'text',
			'val'   => isset( $param['menu_1']['item_tooltip'][ $i ] ) ? $param['menu_1']['item_tooltip'][ $i ] : '',
		);


//    $smooth = isset( $param[ 'menu_1' ][ 'scroll' ][ $i ] ) ? $param[ 'menu_1' ][ 'scroll' ][ $i ] : '';

		// Type of the item
		$item_type_[ $i ] = array(
			'name'   => 'param[menu_1][item_type][]',
			'type'   => 'select',
			'class'  => 'item-type',
			'val'    => isset( $param['menu_1']['item_type'][ $i ] ) ? $param['menu_1']['item_type'][ $i ] : '',
			'option' => array(
				'link'          => esc_attr__( 'Link', 'side-menu' ),
				'share'         => esc_attr__( 'Share', 'side-menu' ),
				'translate'     => esc_attr__( 'Translate', 'side-menu' ),
				'next_post'     => esc_attr__( 'Next Post', 'side-menu' ),
				'previous_post' => esc_attr__( 'Previous Post', 'side-menu' ),
				'search'        => esc_attr__( 'Search', 'side-menu' ),
				'print'         => esc_attr__( 'Print', 'side-menu' ),
				'totop'         => esc_attr__( 'Scroll to Top', 'side-menu' ),
				'tobottom'      => esc_attr__( 'Scroll to Bottom', 'side-menu' ),
				'smoothscroll'  => esc_attr__( 'Smooth Scroll', 'side-menu' ),
				'scrollSpy'     => esc_attr__( 'Scrollspy', 'side-menu' ),
				'goback'        => esc_attr__( 'Go Back', 'side-menu' ),
				'goforward'     => esc_attr__( 'Go Forward', 'side-menu' ),
				'email'         => esc_attr__( 'Email', 'side-menu' ),
				'telephone'     => esc_attr__( 'Telephone', 'side-menu' ),
				'login'         => esc_attr__( 'Login', 'side-menu' ),
				'logout'        => esc_attr__( 'Logout', 'side-menu' ),
				'register'      => esc_attr__( 'Register', 'side-menu' ),
				'lostpassword'  => esc_attr__( 'Lostpassword', 'side-menu' ),
				'id'            => esc_attr__( 'Item only with ID', 'side-menu' ),
				'class'         => esc_attr__( 'Item only with Class', 'side-menu' ),
				'modal'         => esc_attr__( 'Open Modal Window', 'side-menu' ),
				'shiftnav'      => esc_attr__( 'ShiftNav Menu', 'side-menu' ),
			),
			'func'   => 'itemtype(this);',
		);


		// Link URL
		$item_link_[ $i ] = array(
			'name' => 'param[menu_1][item_link][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['item_link'][ $i ] ) ? $param['menu_1']['item_link'][ $i ] : '',
		);


		// Open link in a new window
		$new_tab_[ $i ] = array(
			'name'  => 'param[menu_1][new_tab][]',
			'class' => '',
			'type'  => 'checkbox',
			'val'   => isset( $param['menu_1']['new_tab'][ $i ] ) ? $param['menu_1']['new_tab'][ $i ] : 0,
			'func'  => '',
			'sep'   => '',
		);


		// Social Networks
		$item_share_[ $i ] = array(
			'name'   => 'param[menu_1][item_share][]',
			'type'   => 'select',
			'val'    => isset( $param['menu_1']['item_share'][ $i ] ) ? $param['menu_1']['item_share'][ $i ] : '',
			'option' => array(
				'Facebook'         => esc_attr__( 'Facebook', 'side-menu' ),
				'VK'               => esc_attr__( 'VK', 'side-menu' ),
				'Twitter'          => esc_attr__( 'Twitter', 'side-menu' ),
				'Linkedin'         => esc_attr__( 'Linkedin', 'side-menu' ),
				'Odnoklassniki'    => esc_attr__( 'Odnoklassniki', 'side-menu' ),
				'Google'           => esc_attr__( 'Google', 'side-menu' ),
				'Pinterest'        => esc_attr__( 'Pinterest', 'side-menu' ),
				'xing'             => esc_attr__( 'XING', 'side-menu' ),
				'myspace'          => esc_attr__( 'Myspace', 'side-menu' ),
				'weibo'            => esc_attr__( 'Weibo', 'side-menu' ),
				'buffer'           => esc_attr__( 'Buffer', 'side-menu' ),
				'stumbleupon'      => esc_attr__( 'StumbleUpon', 'side-menu' ),
				'reddit'           => esc_attr__( 'Reddit', 'side-menu' ),
				'tumblr'           => esc_attr__( 'Tumblr', 'side-menu' ),
				'blogger'          => esc_attr__( 'Blogger', 'side-menu' ),
				'livejournal'      => esc_attr__( 'LiveJournal', 'side-menu' ),
				'pocket'           => esc_attr__( 'Pocket', 'side-menu' ),
				'telegram'         => esc_attr__( 'Telegram', 'side-menu' ),
				'skype'            => esc_attr__( 'Skype', 'side-menu' ),
				'email'            => esc_attr__( 'Email', 'side-menu' ),
				'draugiem'         => esc_attr__( 'Draugiem', 'side-menu' ),
				'whatsapp'         => esc_attr__( 'Whatsapp', 'side-menu' ),
				'diaspora'         => esc_attr__( 'Diaspora', 'side-menu' ),
				'digg'             => esc_attr__( 'Digg', 'side-menu' ),
				'douban'           => esc_attr__( 'Douban', 'side-menu' ),
				'evernote'         => esc_attr__( 'Evernote', 'side-menu' ),
				'flipboard'        => esc_attr__( 'Flipboard', 'side-menu' ),
				'google-bookmarks' => esc_attr__( 'Google Bookmarks', 'side-menu' ),
				'hacker-news'      => esc_attr__( 'Hacker News', 'side-menu' ),
				'instapaper'       => esc_attr__( 'Instapaper', 'side-menu' ),
				'line'             => esc_attr__( 'Line', 'side-menu' ),
				'qzone'            => esc_attr__( 'Qzone', 'side-menu' ),
				'renren'           => esc_attr__( 'Renren', 'side-menu' ),
			),
			'func'   => '',
		);

		$gtranslate_[ $i ] = array(
			'name'   => 'param[menu_1][gtranslate][]',
			'type'   => 'select',
			'val'    => isset( $param['menu_1']['gtranslate'][ $i ] ) ? $param['menu_1']['gtranslate'][ $i ] : '',
			'class'  => 'gtranslate',
			'option' => array(
				'af'  => esc_attr__( 'Afrikaans', 'side-menu' ),
				'sq'  => esc_attr__( 'Albanian', 'side-menu' ),
				'am'  => esc_attr__( 'Amharic', 'side-menu' ),
				'ar'  => esc_attr__( 'Arabic', 'side-menu' ),
				'hy'  => esc_attr__( 'Armenian', 'side-menu' ),
				'az'  => esc_attr__( 'Azerbaijani', 'side-menu' ),
				'eu'  => esc_attr__( 'Basque', 'side-menu' ),
				'be'  => esc_attr__( 'Belarusian', 'side-menu' ),
				'bn'  => esc_attr__( 'Bengali', 'side-menu' ),
				'bs'  => esc_attr__( 'Bosnian', 'side-menu' ),
				'bg'  => esc_attr__( 'Bulgarian', 'side-menu' ),
				'ca'  => esc_attr__( 'Catalan', 'side-menu' ),
				'ceb' => esc_attr__( 'Cebuano', 'side-menu' ),
				'ny'  => esc_attr__( 'Chichewa', 'side-menu' ),
				'co'  => esc_attr__( 'Corsican', 'side-menu' ),
				'hr'  => esc_attr__( 'Croatian', 'side-menu' ),
				'cs'  => esc_attr__( 'Czech', 'side-menu' ),
				'da'  => esc_attr__( 'Danish', 'side-menu' ),
				'nl'  => esc_attr__( 'Dutch', 'side-menu' ),
				'en'  => esc_attr__( 'English', 'side-menu' ),
				'eo'  => esc_attr__( 'Esperanto', 'side-menu' ),
				'et'  => esc_attr__( 'Estonian', 'side-menu' ),
				'tl'  => esc_attr__( 'Filipino', 'side-menu' ),
				'fi'  => esc_attr__( 'Finnish', 'side-menu' ),
				'fr'  => esc_attr__( 'French', 'side-menu' ),
				'fy'  => esc_attr__( 'Frisian', 'side-menu' ),
				'gl'  => esc_attr__( 'Galician', 'side-menu' ),
				'ka'  => esc_attr__( 'Georgian', 'side-menu' ),
				'de'  => esc_attr__( 'German', 'side-menu' ),
				'el'  => esc_attr__( 'Greek', 'side-menu' ),
				'gu'  => esc_attr__( 'Gujarati', 'side-menu' ),
				'ht'  => esc_attr__( 'Haitian Creole', 'side-menu' ),
				'ha'  => esc_attr__( 'Hausa', 'side-menu' ),
				'haw' => esc_attr__( 'Hawaiian', 'side-menu' ),
				'iw'  => esc_attr__( 'Hebrew', 'side-menu' ),
				'hi'  => esc_attr__( 'Hindi', 'side-menu' ),
				'hmn' => esc_attr__( 'Hmong', 'side-menu' ),
				'hu'  => esc_attr__( 'Hungarian', 'side-menu' ),
				'is'  => esc_attr__( 'Icelandic', 'side-menu' ),
				'ig'  => esc_attr__( 'Igbo', 'side-menu' ),
				'id'  => esc_attr__( 'Indonesian', 'side-menu' ),
				'ga'  => esc_attr__( 'Irish', 'side-menu' ),
				'it'  => esc_attr__( 'Italian', 'side-menu' ),
				'ja'  => esc_attr__( 'Japanese', 'side-menu' ),
				'jw'  => esc_attr__( 'Javanese', 'side-menu' ),
				'kn'  => esc_attr__( 'Kannada', 'side-menu' ),
				'kk'  => esc_attr__( 'Kazakh', 'side-menu' ),
				'km'  => esc_attr__( 'Khmer', 'side-menu' ),
				'ko'  => esc_attr__( 'Korean', 'side-menu' ),
				'ku'  => esc_attr__( 'Kurdish (Kurmanji)', 'side-menu' ),
				'ky'  => esc_attr__( 'Kyrgyz', 'side-menu' ),
				'lo'  => esc_attr__( 'Lao', 'side-menu' ),
				'la'  => esc_attr__( 'Latin', 'side-menu' ),
				'lv'  => esc_attr__( 'Latvian', 'side-menu' ),
				'lb'  => esc_attr__( 'Luxembourgish', 'side-menu' ),
				'mk'  => esc_attr__( 'Macedonian', 'side-menu' ),
				'mg'  => esc_attr__( 'Malagasy', 'side-menu' ),
				'ms'  => esc_attr__( 'Malay', 'side-menu' ),
				'ml'  => esc_attr__( 'Malayalam', 'side-menu' ),
				'mt'  => esc_attr__( 'Maltese', 'side-menu' ),
				'mi'  => esc_attr__( 'Maori', 'side-menu' ),
				'mr'  => esc_attr__( 'Marathi', 'side-menu' ),
				'mn'  => esc_attr__( 'Mongolian', 'side-menu' ),
				'my'  => esc_attr__( 'Myanmar (Burmese)', 'side-menu' ),
				'ne'  => esc_attr__( 'Nepali', 'side-menu' ),
				'no'  => esc_attr__( 'Norwegian', 'side-menu' ),
				'ps'  => esc_attr__( 'Pashto', 'side-menu' ),
				'fa'  => esc_attr__( 'Persian', 'side-menu' ),
				'pl'  => esc_attr__( 'Polish', 'side-menu' ),
				'pt'  => esc_attr__( 'Portuguese', 'side-menu' ),
				'pa'  => esc_attr__( 'Punjabi', 'side-menu' ),
				'ro'  => esc_attr__( 'Romanian', 'side-menu' ),
				'ru'  => esc_attr__( 'Russian', 'side-menu' ),
				'sm'  => esc_attr__( 'Samoan', 'side-menu' ),
				'gd'  => esc_attr__( 'Scottish Gaelic', 'side-menu' ),
				'sr'  => esc_attr__( 'Serbian', 'side-menu' ),
				'st'  => esc_attr__( 'Sesotho', 'side-menu' ),
				'sn'  => esc_attr__( 'Shona', 'side-menu' ),
				'sd'  => esc_attr__( 'Sindhi', 'side-menu' ),
				'si'  => esc_attr__( 'Sinhala', 'side-menu' ),
				'sk'  => esc_attr__( 'Slovak', 'side-menu' ),
				'sl'  => esc_attr__( 'Slovenian', 'side-menu' ),
				'so'  => esc_attr__( 'Somali', 'side-menu' ),
				'es'  => esc_attr__( 'Spanish', 'side-menu' ),
				'su'  => esc_attr__( 'Sudanese', 'side-menu' ),
				'sw'  => esc_attr__( 'Swahili', 'side-menu' ),
				'sv'  => esc_attr__( 'Swedish', 'side-menu' ),
				'tg'  => esc_attr__( 'Tajik', 'side-menu' ),
				'ta'  => esc_attr__( 'Tamil', 'side-menu' ),
				'te'  => esc_attr__( 'Telugu', 'side-menu' ),
				'th'  => esc_attr__( 'Thai', 'side-menu' ),
				'tr'  => esc_attr__( 'Turkish', 'side-menu' ),
				'uk'  => esc_attr__( 'Ukrainian', 'side-menu' ),
				'ur'  => esc_attr__( 'Urdu', 'side-menu' ),
				'uz'  => esc_attr__( 'Uzbek', 'side-menu' ),
				'vi'  => esc_attr__( 'Vietnamese', 'side-menu' ),
				'cy'  => esc_attr__( 'Welsh', 'side-menu' ),
				'xh'  => esc_attr__( 'Xhosa', 'side-menu' ),
				'yi'  => esc_attr__( 'Yiddish', 'side-menu' ),
				'yo'  => esc_attr__( 'Yoruba', 'side-menu' ),
				'zu'  => esc_attr__( 'Zulu', 'side-menu' ),
			),
			'func'   => '',
		);

		// Modal
		$item_modal_[ $i ] = array(
			'name' => 'param[menu_1][item_modal][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['item_modal'][ $i ] ) ? $param['menu_1']['item_modal'][ $i ] : '',
		);

		// Font color
		$color_[ $i ] = array(
			'name' => 'param[menu_1][color][]',
			'type' => 'color',
			'val'  => isset( $param['menu_1']['color'][ $i ] ) ? $param['menu_1']['color'][ $i ] : '#ffffff',
		);

		// Icon Сolor
		$iconcolor_[ $i ] = array(
			'name' => 'param[menu_1][iconcolor][]',
			'type' => 'color',
			'val'  => isset( $param['menu_1']['iconcolor'][ $i ] ) ? $param['menu_1']['iconcolor'][ $i ] : '#ffffff',
		);

		// Background
		$bcolor_[ $i ] = array(
			'name' => 'param[menu_1][bcolor][]',
			'type' => 'color',
			'val'  => isset( $param['menu_1']['bcolor'][ $i ] ) ? $param['menu_1']['bcolor'][ $i ] : '#128be0',
		);

		// Background Hover
		$hbcolor_[ $i ] = array(
			'name' => 'param[menu_1][hbcolor][]',
			'type' => 'color',
			'val'  => isset( $param['menu_1']['hbcolor'][ $i ] ) ? $param['menu_1']['hbcolor'][ $i ] : '#128be0',
		);

		// Update to version 4.0
		$link_type = isset( $param['menu_1']['item_type'][ $i ] ) ? $param['menu_1']['item_type'][ $i ] : '';
		$class_id  = '';
		if ( $link_type === 'id' ) {
			$class_id                           = ! empty( $param['menu_1']['item_modal'][ $i ] ) ? $param['menu_1']['item_modal'][ $i ] : '';
			$param['menu_1']['button_id'][ $i ] = $class_id;
			$param['menu_1']['item_type'][ $i ] = 'link';
		} elseif ( $link_type === 'class' ) {
			$class_id                              = ! empty( $param['menu_1']['item_modal'][ $i ] ) ? $param['menu_1']['item_modal'][ $i ] : '';
			$param['menu_1']['button_class'][ $i ] = $class_id;
			$param['menu_1']['item_type'][ $i ]    = 'link';
		}

		$button_id_[ $i ] = array(
			'name' => 'param[menu_1][button_id][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['button_id'][ $i ] ) ? $param['menu_1']['button_id'][ $i ] : $class_id,
		);

		$button_class_[ $i ] = array(
			'name' => 'param[menu_1][button_class][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['button_class'][ $i ] ) ? $param['menu_1']['button_class'][ $i ] : $class_id,
		);

		$link_rel_[ $i ] = array(
			'name' => 'param[menu_1][link_rel][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['link_rel'][ $i ] ) ? $param['menu_1']['link_rel'][ $i ] : '',
		);

		// Hold open item when menu load
		$hold_open_[ $i ] = array(
			'name'  => 'param[menu_1][hold_open][]',
			'class' => '',
			'type'  => 'checkbox',
			'val'   => isset( $param['menu_1']['hold_open'][ $i ] ) ? $param['menu_1']['hold_open'][ $i ] : 0,
			'func'  => '',
			'sep'   => '',
		);

		$sub_item_[ $i ] = array(
			'name'  => 'param[menu_1][sub_item][]',
			'class' => 'sub-item',
			'type'  => 'checkbox',
			'val'   => isset( $param['menu_1']['sub_item'][ $i ] ) ? $param['menu_1']['sub_item'][ $i ] : 0,
			'func'  => '',
			'sep'   => '',
		);

		$close_item_[ $i ] = array(
			'name'   => 'param[menu_1][close_item][]',
			'type'   => 'number',
			'val'    => isset( $param['menu_1']['close_item'][ $i ] ) ? $param['menu_1']['close_item'][ $i ] : '0',
			'option' => array(
				'min' => '0'
			)
		);


		// Modal
		$item_modal_[ $i ] = array(
			'name' => 'param[menu_1][item_modal][]',
			'type' => 'text',
			'val'  => isset( $param['menu_1']['item_modal'][ $i ] ) ? $param['menu_1']['item_modal'][ $i ] : '',
		);

		// Extra text
		$item_text_[ $i ] = array(
			'name'  => 'param[menu_1][item_text][]',
			'class' => '',
			'id'    => 'item_text_' . $i,
			'type'  => 'shorteditor',
			'val'   => isset( $param['menu_1']['item_text'][ $i ] ) ? wp_kses_post( $param['menu_1']['item_text'][ $i ] ) : '',
		);

		$item_text_size_[ $i ] = array(
			'name' => 'param[menu_1][item_text_size][]',
			'type' => 'number',
			'val'  => isset( $param['menu_1']['item_text_size'][ $i ] ) ? $param['menu_1']['item_text_size'][ $i ] : '16',
		);

		$item_text_width_[ $i ] = array(
			'name'  => 'param[menu_1][item_text_width][]',
			'class' => '',
			'type'  => 'number',
			'val'   => isset( $param['menu_1']['item_text_width'][ $i ] ) ? $param['menu_1']['item_text_width'][ $i ] : '270',
		);
	}
}


$item_icon_help = array(
	'title' => esc_attr__( 'Set the icon for menu item. If you want use the custom item:', 'side-menu' ),
	'ul'    => array(
		esc_attr__( '1. Check the box on "custom"', 'side-menu' ),
		esc_attr__( '2. Upload the icon in Media Library', 'side-menu' ),
		esc_attr__( '3. Copy the URL to icon', 'side-menu' ),
		esc_attr__( '4. Paste the icon URL to field', 'side-menu' ),
	),
);

$item_tooltip_help = array(
	'text' => esc_attr__( 'Set the text for menu item.', 'side-menu' ),
);

$item_type_help = array(
	'text' => esc_attr__( 'Select the type of menu item. Explanation of some types:', 'side-menu' ),
	'ul'   => array(
		esc_attr__( '<strong>Smooth Scroll</strong> - Smooth scrolling of the page to the specified anchors on the page.',
			'side-menu' ),
		esc_attr__( '<strong>ShiftNav Menu</strong> - open the menu, wich create via the plugin ShiftNav.',
			'side-menu' ),
	),
);

$hold_open_help = array(
	'text' => esc_attr__( 'When the page loads, the menu item will open.', 'side-menu' ),
);

$button_id_help = array(
	'text' => esc_attr__( 'Set the attribute ID for the menu item or left empty.', 'side-menu' ),
);

$button_class_help = array(
	'text' => esc_attr__( 'Set the attribute CLASS for the menu item or left empty.', 'side-menu' ),
);

$close_item_help = array(
	'text' => esc_attr__( 'Set the value in seconds after how long it is necessary to close the item. Leave the field empty or with a value of 0 for not to close the item.',
		'side-menu' ),
);

$image_alt_help = array(
	'text' => esc_attr__( 'Set the attribute Alt for custom image.', 'side-menu' ),
);

$item_text_help = array(
	'text' => esc_attr__( 'Extra text under the Label.', 'side-menu' ),
);

$item_custom_text_check_help = array(
	'text' => esc_attr__( 'You can set the Emoji, Glyphs or Leter.', 'side-menu' ),
);