<?php
/**
 * Main Settings param
 *
 * @package     Wow_Plugin
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */


// Position of the menu
$menu = array(
	'id'     => 'position',
	'name'   => 'param[menu]',
	'type'   => 'select',
	'val'    => isset( $param['menu'] ) ? $param['menu'] : 'left',
	'option' => array(
		'left'  => esc_attr__( 'Left', 'side-menu' ),
		'right' => esc_attr__( 'Right', 'side-menu' ),
	),
);

// Menu position help
$menu_help = array(
	'text' => esc_attr__( 'Specify menu position on screen.', 'side-menu' ),
);

// Menu Vertical alignment
$align = array(
	'name'   => 'param[align]',
	'id'     => 'align',
	'class'  => '',
	'type'   => 'select',
	'val'    => isset( $param['align'] ) ? $param['align'] : 'center',
	'option' => array(
		'top'    => esc_attr__( 'Top', 'side-menu' ),
		'center' => esc_attr__( 'Center', 'side-menu' ),
		'bottom' => esc_attr__( 'Bottom', 'side-menu' ),
	),
);

// Menu Vertical alignment help
$align_help = array(
	'text' => esc_attr__( 'Specify the vertical positioning of the menu.', 'side-menu' ),
);

// Offset from start position
$margin = array(
	'name'   => 'param[margin]',
	'id'     => 'margin',
	'type'   => 'number',
	'val'    => isset( $param['margin'] ) ? $param['margin'] : '0',
	'option' => array(
		'step'        => '1',
		'placeholder' => '10',
	),
);

$margin_help = array(
	'text' => esc_attr__( 'Offset from base position on screen in (px).', 'side-menu' ),
);

// Menu item Width
$width = array(
	'name'   => 'param[width]',
	'id'     => 'width',
	'type'   => 'number',
	'val'    => isset( $param['width'] ) ? $param['width'] : '240',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '240',
	),
);

$width_help = array(
	'text' => esc_attr__( 'The width of the menu items when hovering on the element in (px).', 'side-menu' ),
);

// Menu item height
$height = array(
	'name'   => 'param[height]',
	'id'     => 'height',
	'type'   => 'number',
	'val'    => isset( $param['height'] ) ? $param['height'] : '40',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '40',
	),
);

$height_help = array(
	'text' => esc_attr__( 'The height of the menu items in (px).', 'side-menu' ),
);

// Space between items
$gap = array(
	'name'   => 'param[gap]',
	'id'     => 'gap',
	'type'   => 'number',
	'val'    => isset( $param['gap'] ) ? $param['gap'] : '2',
	'option' => array(
		'step'        => '1',
		'placeholder' => '2',
	),
);

$gap_help = array(
	'text' => esc_attr__( 'The height of the menu items in (px).', 'side-menu' ),
);

// Font size 
$fontsize = array(
	'name'   => 'param[fontsize]',
	'id'     => 'fontsize',
	'type'   => 'number',
	'val'    => isset( $param['fontsize'] ) ? $param['fontsize'] : '24',
	'option' => array(
		'step'        => '1',
		'placeholder' => '24',
	),
);

// Font size helper
$fontsize_help = array(
	'text' => esc_attr__( 'Set the font size for label content in px', 'side-menu' ),
);


// Font Style
$fontstyle = array(
	'id'     => 'fontstyle',
	'name'   => 'param[fontstyle]',
	'type'   => 'select',
	'val'    => isset( $param['fontstyle'] ) ? $param['fontstyle'] : 'normal',
	'option' => array(
		'normal' => 'Normal',
		'italic' => 'Italic',
	),
);

// Font weight
$fontweight = array(
	'name'   => 'param[fontweight]',
	'id'     => 'fontweight',
	'class'  => '',
	'type'   => 'select',
	'val'    => isset( $param['fontweight'] ) ? $param['fontweight'] : '',
	'option' => array(
		'normal'  => esc_attr__( 'Normal', 'side-menu' ),
		'bold'    => esc_attr__( 'Bold', 'side-menu' ),
		'bolder'  => esc_attr__( 'Bolder', 'side-menu' ),
		'lighter' => esc_attr__( 'Lighter', 'side-menu' ),
	),
);

// Icon size
$iconsize = array(
	'name'   => 'param[iconsize]',
	'id'     => 'iconsize',
	'type'   => 'number',
	'val'    => isset( $param['iconsize'] ) ? $param['iconsize'] : '24',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '24',
	),
);

$iconsize_help = array(
	'text' => esc_attr__( 'Set the size for icon in px', 'side-menu' ),
);


// Mobile Size

$mobile = array(
	'name'   => 'param[mobile]',
	'id'     => 'mobile',
	'type'   => 'checkbox',
	'val'   => isset( $param[ 'mobile' ] ) ? $param[ 'mobile' ] : 0,
	'func'  => '',
	'sep'   => '',
);

$m_screen = array(
	'name'   => 'param[m_screen]',
	'id'     => 'm_screen',
	'type'   => 'number',
	'val'    => isset( $param['m_screen'] ) ? $param['m_screen'] : '768',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '768',
	),
);

$m_height = array(
	'name'   => 'param[m_height]',
	'id'     => 'm_height',
	'type'   => 'number',
	'val'    => isset( $param['m_height'] ) ? $param['m_height'] : '40',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '40',
	),
);

$m_fontsize = array(
	'name'   => 'param[m_fontsize]',
	'id'     => 'm_fontsize',
	'type'   => 'number',
	'val'    => isset( $param['m_fontsize'] ) ? $param['m_fontsize'] : '24',
	'option' => array(
		'step'        => '1',
		'placeholder' => '24',
	),
);

$m_iconsize = array(
	'name'   => 'param[m_iconsize]',
	'id'     => 'm_iconsize',
	'type'   => 'number',
	'val'    => isset( $param['m_iconsize'] ) ? $param['m_iconsize'] : '24',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '24',
	),
);

// Custom image width
$iwidth = array(
	'name'   => 'param[iwidth]',
	'id'     => 'iwidth',
	'type'   => 'number',
	'val'    => isset( $param['iwidth'] ) ? $param['iwidth'] : '24',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
	'func'   => '',
	'sep'    => '',
);

$iwidth_help = array(
	'text' => esc_attr__( 'Set the size for Custom icon in px', 'side-menu' ),
);

// Border width (px)
$bwidth = array(
	'name'   => 'param[bwidth]',
	'id'     => 'bwidth',
	'type'   => 'number',
	'val'    => isset( $param['bwidth'] ) ? $param['bwidth'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
);

$bwidth_help = array(
	'text' => esc_attr__( 'Set the border width for menu items in px', 'side-menu' ),
);

// Border radius top
$bradiustop = array(
	'name'   => 'param[bradiustop]',
	'id'     => 'bradiustop',
	'type'   => 'number',
	'val'    => isset( $param['bradiustop'] ) ? $param['bradiustop'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
);

$bradiustop_help = array(
	'text' => esc_attr__( 'Set the radius for the menu item top corner in px', 'side-menu' ),
);

// Border radius bottom
$bradiusbottom = array(
	'name'   => 'param[bradiusbottom]',
	'id'     => 'bradiusbottom',
	'type'   => 'number',
	'val'    => isset( $param['bradiusbottom'] ) ? $param['bradiusbottom'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
	'func'   => '',
	'sep'    => '',
);

$bradiusbottom_help = array(
	'text' => esc_attr__( 'Set the radius for the menu item bottom corner in px', 'side-menu' ),
);

// Border color
$bcolor = array(
	'name' => 'param[bcolor]',
	'id'   => 'bcolor',
	'type' => 'color',
	'val'  => isset( $param['bcolor'] ) ? $param['bcolor'] : 'rgba(0,0,0,0.75)',
	'sep'  => '',
);

$bcolor_help = array(
	'text' => esc_attr__( 'Set the border color', 'side-menu' ),
);

// Shadow
$shadow = array(
	'name'   => 'param[shadow]',
	'class'  => '',
	'type'   => 'select',
	'val'    => isset( $param['shadow'] ) ? $param['shadow'] : 'shadow',
	'option' => array(
		'shadow' => esc_attr__( 'Yes', 'side-menu' ),
		''       => esc_attr__( 'No', 'side-menu' ),
	),
);

// Shadow help
$shadow_help = array(
	'text' => esc_attr__( 'If there should be a shadow on buttons.', 'side-menu' ),
);

// Z-index
$zindex = array(
	'name'   => 'param[zindex]',
	'type'   => 'number',
	'val'    => isset( $param['zindex'] ) ? round( $param['zindex'] ) : '9',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '9',
	),
);

// Z-index helper
$zindex_help = array(
	'text' => esc_attr__( 'The z-index property specifies the stack order of an element. An element with greater stack order is always in front of an element with a lower stack order.',
		'side-menu' ),
);


// Connect items
$connect = array(
	'id'   => 'connect',
	'name'   => 'param[connect]',
	'type'   => 'select',
	'val'    => isset( $param['connect'] ) ?  $param['connect'] : '',
	'option' => array(
		''           => esc_attr__( 'No', 'side-menu' ),
		'-list-show' => esc_attr__( 'Yes', 'side-menu' ),
	),
	'func' => 'holdOpen()',
);

// Connect helper
$connect_help = array(
	'text' => esc_attr__( 'Show all items on hover. All elements are connected in one block.', 'side-menu' ),
);


// Hold open All items
$hold_open = array(
	'name'  => 'param[hold_open]',
	'class' => '',
	'type'  => 'checkbox',
	'val'   => isset( $param[ 'hold_open' ] ) ? $param[ 'hold_open' ] : 0,
	'func'  => '',
	'sep'   => '',
);


// Show After Position
$showAfterPosition = array(
	'name'   => 'param[showAfterPosition]',
	'type'   => 'number',
	'val'    => isset( $param['showAfterPosition'] ) ? $param['showAfterPosition'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
);

// Show After Position helper
$showAfterPosition_help = array(
	'text' => esc_attr__( 'If the sidebar should be shown only after the page was scrolled beyond a certain point.',
		'side-menu' ),
);

// Hide After Position
$hideAfterPosition = array(
	'name'   => 'param[hideAfterPosition]',
	'type'   => 'number',
	'val'    => isset( $param['hideAfterPosition'] ) ? $param['hideAfterPosition'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
);

// Show After Position helper
$hideAfterPosition_help = array(
	'text' => esc_attr__( 'If the sidebar should be hide only after the page was scrolled beyond a certain point.',
		'side-menu' ),
);


// Show After Time
$showAfterTimer = array(
	'name'   => 'param[showAfterTimer]',
	'type'   => 'number',
	'val'    => isset( $param['showAfterTimer'] ) ? $param['showAfterTimer'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
);

// Show After Time helper
$showAfterTimer_help = array(
	'text' => esc_attr__( 'Show the menu after the specified seconds.',
		'side-menu' ),
);

// Hide After Time
$hideAfterTimer = array(
	'name'   => 'param[hideAfterTimer]',
	'type'   => 'number',
	'val'    => isset( $param['hideAfterTimer'] ) ? $param['hideAfterTimer'] : '0',
	'option' => array(
		'min'         => '0',
		'step'        => '1',
		'placeholder' => '0',
	),
);

// Hide After Time helper
$hideAfterTimer_help = array(
	'text' => esc_attr__( 'Hide the menu after the specified seconds.',
		'side-menu' ),
);

$deactivateMobileRule = array(
	'name'   => 'param[touch]',
	'id'     => 'touch',
	'type'   => 'checkbox',
	'val'   => isset( $param[ 'touch' ] ) ? $param[ 'touch' ] : 0,
);