<?php
/**
 * Main Settings
 *
 * @package     Wow_Plugin
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

include_once( 'icons.php' );
$icons_new = array();
foreach ( $icons as $key => $value ) {
	$icons_new[ $value ] = $value;
}

$status = array(
	'id'   => 'menu_status',
	'name' => 'param[status]',
	'type' => 'checkbox',
	'val'  => isset( $param['status'] ) ? $param['status'] : 0,
);

$status_help = array(
	'text' => __( 'If check - the menu not displayed on the frontend. If uncheck - the menu will show on the frontend.', 'side-menu' ),
);

$test_mode = array(
	'id'   => 'test_mode',
	'name' => 'param[test_mode]',
	'type' => 'checkbox',
	'val'  => isset( $param['test_mode'] ) ? $param['test_mode'] : 0,
);

$test_mode_help = array(
	'text' => __( 'If test mode is enabled, the form will show for admin only.', 'side-menu' ),
);


$tax_args   = array(
	'public'   => true,
	'_builtin' => false
);
$output     = 'names';
$operator   = 'and';
$taxonomies = get_taxonomies( $tax_args, $output, $operator );

$show_option = array(
	'general_start' => esc_attr__( 'General', 'side-menu' ),
	'all'           => esc_attr__( 'All site', 'side-menu' ),
	'homepage'      => esc_attr__( 'Home Page', 'side-menu' ),
	'searchpage'    => esc_attr__( 'Search Result Page', 'side-menu' ),
	'archivepage'   => esc_attr__( 'Archive Page', 'side-menu' ),
	'error_page'    => esc_attr__( '404 Error Page', 'side-menu' ),
	'posts_page'    => esc_attr__( 'Posts page', 'side-menu' ),
	'shortecode'    => esc_attr__( 'Shortcode', 'side-menu' ),
	'general_end'   => esc_attr__( 'General', 'side-menu' ),
	'post_start'    => esc_attr__( 'Posts', 'side-menu' ),
	'onlypost'      => esc_attr__( 'All Posts', 'side-menu' ),
	'posts'         => esc_attr__( 'Posts: ID', 'side-menu' ),
	'postsincat'    => esc_attr__( 'Posts: with Category', 'side-menu' ),
	'expost'        => esc_attr__( 'Posts: Exclude', 'side-menu' ),
	'post_type'     => esc_attr__( 'Custom Posts:', 'side-menu' ),
	'post_end'      => esc_attr__( 'Posts End', 'side-menu' ),
	'page_start'    => esc_attr__( 'Pages', 'side-menu' ),
	'onlypage'      => esc_attr__( 'All pages', 'side-menu' ),
	'pages'         => esc_attr__( 'Pages: ID', 'side-menu' ),
	'expage'        => esc_attr__( 'Pages: Exclude', 'side-menu' ),
	'page_end'      => esc_attr__( 'Pages End', 'side-menu' ),

);
if ( $taxonomies ) {
	$show_option['taxonomy'] = esc_attr__( 'Taxonomy', 'side-menu' );
}

$show = array(
	'id'     => 'show',
	'name'   => 'param[show]',
	'type'   => 'select',
	'val'    => isset( $param['show'] ) ? $param['show'] : 'all',
	'option' => $show_option,
	'func'   => 'showchange(this);',
	'sep'    => 'p',
);

$show_help = array(
	'text' => esc_attr__( 'Choose a condition to target to specific content.', 'side-menu' ),
);

// Taxonomy
$taxonomy_option = array();
if ( $taxonomies ) {
	foreach ( $taxonomies as $taxonomy ) {
		$taxonomy_option[ $taxonomy ] = $taxonomy;
	}
}

$taxonomy = array(
	'id'     => 'taxonomy',
	'name'   => 'param[taxonomy]',
	'type'   => 'select',
	'val'    => isset( $param['taxonomy'] ) ? $param['taxonomy'] : '',
	'option' => $taxonomy_option,
	'sep'    => 'p',
);

// Content ID'sa
$id_post = array(
	'id'     => 'id_post',
	'name'   => 'param[id_post]',
	'type'   => 'text',
	'val'    => isset( $param['id_post'] ) ? $param['id_post'] : '',
	'option' => array(
		'placeholder' => esc_attr__( 'Enter IDs, separated by comma.', 'side-menu' ),
	),
	'sep'    => 'p',
);