<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Tergeting settings
 *
 * @package     Lead_Generation
 * @subpackage  Settings
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */


// Enable Don’t show on screens more than
$include_more_screen = array(
	'id'   => 'include_more_screen',
	'name' => 'param[include_more_screen]',
	'type' => 'checkbox',
	'val'  => isset( $param['include_more_screen'] ) ? $param['include_more_screen'] : 0,
	'func' => 'screen_more(this);',
);

// Show on screens helper
$show_screen_help = array(
	'text' => __( 'Specify the window breakpoint in px when the button will be shown.', 'side-menu' ),
);

// Max screen value
$screen_more = array(
	'id'     => 'screenmore',
	'name'   => 'param[screen_more]',
	'type'   => 'number',
	'val'    => isset( $param['screen_more'] ) ? $param['screen_more'] : 1024,
	'option' => array(
		'min'         => '0',
		'max'         => '3000',
		'step'        => '1',
		'placeholder' => '1024',
	),
	'sep'    => 'p',
);

// Enable Don’t show on screens less than
$include_mobile = array(
	'id'   => 'include_mobile',
	'name' => 'param[include_mobile]',
	'type' => 'checkbox',
	'val'  => isset( $param['include_mobile'] ) ? $param['include_mobile'] : 0,
	'func' => 'screen_less(this);',
);

// Enable Don’t show on screens less than helper
$include_mobile_help = array(
	'text' => __( 'Specify the window breakpoint ( mix width) in px.', 'side-menu' ),
);

// Min screen value
$screen = array(
	'id'     => 'screen',
	'name'   => 'param[screen]',
	'type'   => 'number',
	'val'    => isset( $param['screen'] ) ? $param['screen'] : 480,
	'option' => array(
		'min'         => '0',
		'max'         => '3000',
		'step'        => '1',
		'placeholder' => '480',
	),
);

// Show for users
$item_user = array(
	'id'     => 'item_user',
	'name'   => 'param[item_user]',
	'type'   => 'select',
	'class'  => 'item_user',
	'val'    => isset( $param['item_user'] ) ? $param['item_user'] : '1',
	'option' => array(
		'1' => esc_attr__( 'All Users', 'side-menu' ),
		'2' => esc_attr__( 'Authorized Users', 'side-menu' ),
		'3' => esc_attr__( 'Unauthorized Users', 'side-menu' ),
	),
);


// Users role
$add_users      = array( 'all' => array( 'name' => __( 'All Users', 'side-menu' ) ) );
$editable_role  = array_reverse( get_editable_roles() );
$editable_roles = array_merge( $add_users, $editable_role );
$users_arr      = array();
foreach ( $editable_roles as $role => $details ) {
	$name                           = translate_user_role( $details['name'] );
	$users_arr[ esc_attr( $role ) ] = $name;
}

$user_role = array(
	'id'     => 'users_roles',
	'name'   => 'param[user_role]',
	'type'   => 'select',
	'val'    => isset( $param['user_role'] ) ? $param['user_role'] : 'all',
	'option' => $users_arr,
);

// Enable Depending on the language
$depending_language = array(
	'id'   => 'depending_language',
	'name' => 'param[depending_language]',
	'type' => 'checkbox',
	'val'  => isset( $param['depending_language'] ) ? $param['depending_language'] : 0,
	'func' => 'languages(this);',
);

// Languages
$lang = array(
	'id'     => 'language',
	'name'   => 'param[lang]',
	'type'   => 'select',
	'val'    => isset( $param['lang'] ) ? $param['lang'] : 'all',
	'option' => array(
		'ar'  => 'العربية',
		'az'  => 'Azərbaycan dili',
		'bg'  => 'Български',
		'bn'  => 'বাংলা',
		'bs'  => 'Bosanski',
		'ca'  => 'Català',
		'ceb' => 'Cebuano',
		'cs'  => 'Čeština‎',
		'cy'  => 'Cymraeg',
		'da'  => 'Dansk',
		'de'  => 'Deutsch',
		'el'  => 'Ελληνικά',
		'en'  => 'English',
		'eo'  => 'Esperanto',
		'es'  => 'Español',
		'et'  => 'Eesti',
		'eu'  => 'Euskara',
		'fa'  => 'فارسی',
		'fi'  => 'Suomi',
		'fr'  => 'Français',
		'gd'  => 'Gàidhlig',
		'gl'  => 'Galego',
		'haz' => 'هزاره گی',
		'he'  => 'עִבְרִית',
		'hi'  => 'हिन्दी',
		'hr'  => 'Hrvatski',
		'hu'  => 'Magyar',
		'hy'  => 'Հայերեն',
		'id'  => 'Bahasa Indonesia',
		'is'  => 'Íslenska',
		'it'  => 'Italiano',
		'ja'  => '日本語',
		'ka'  => 'ქართული',
		'ko'  => '한국어',
		'lt'  => 'Lietuvių kalba',
		'mk'  => 'Македонски јазик',
		'mr'  => 'मराठी',
		'ms'  => 'Bahasa Melayu',
		'my'  => 'ဗမာစာ',
		'nb'  => 'Norsk bokmål',
		'nl'  => 'Nederlands',
		'nn'  => 'Norsk nynorsk',
		'oc'  => 'Occitan',
		'pl'  => 'Polski',
		'ps'  => 'پښتو',
		'pt'  => 'Português',
		'ro'  => 'Română',
		'ru'  => 'Русский',
		'sk'  => 'Slovenčina',
		'sl'  => 'Slovenščina',
		'sq'  => 'Shqip',
		'sr'  => 'Српски језик',
		'sv'  => 'Svenska',
		'th'  => 'ไทย',
		'tl'  => 'Tagalog',
		'tr'  => 'Türkçe',
		'ug'  => 'Uyƣurqə',
		'uk'  => 'Українська',
		'vi'  => 'Tiếng Việt',
		'zh'  => '简体中文',
	),
);

// Disable FontAwesome on front-end of the site
$disable_fontawesome = array(
	'id'   => 'disable_fontawesome',
	'name' => 'param[disable_fontawesome]',
	'type' => 'checkbox',
	'val'  => isset( $param['disable_fontawesome'] ) ? $param['disable_fontawesome'] : 0,
);

$disable_fontawesome_help = array(
	'title' => __( 'Disable Font Awesome 5 style on front-end of the site.', 'side-menu' ),
	'ul'    => array(
		__( 'If you already have a Font Awesome 5 installed on the site, you can disable the include the Font Awesome 5 style.',
			'side-menu' ),
	),
);

//region Schedule
$weekday = array(
	'name'    => 'param[weekday]',
	'id'      => 'weekday',
	'type'    => 'select',
	'val'     => isset( $param['weekday'] ) ? $param['weekday'] : 'none',
	'option'  => [
		'none' => esc_attr__( 'Everyday', 'side-menu' ),
		'1'    => esc_attr__( 'Monday', 'side-menu' ),
		'2'    => esc_attr__( 'Tuesday', 'side-menu' ),
		'3'    => esc_attr__( 'Wednesday', 'side-menu' ),
		'4'    => esc_attr__( 'Thursday', 'side-menu' ),
		'5'    => esc_attr__( 'Friday', 'side-menu' ),
		'6'    => esc_attr__( 'Saturday', 'side-menu' ),
		'7'    => esc_attr__( 'Sunday ', 'side-menu' ),

	],
	'tooltip' => esc_attr__( 'Select the day of the week when the notification will be displayed.', 'side-menu' ),
	'icon'    => '',
	'func'    => '',
);

$weekday_help = array(
	'text' => esc_attr__( 'Select the day of the week when the menu will be displayed.', 'side-menu' ),
);

$time_start = array(
	'name' => 'param[time_start]',
	'id'   => 'time_start',
	'type' => 'time',
	'val'  => isset( $param['time_start'] ) ? $param['time_start'] : '00:00',
);

$time_start_help = array(
	'text' => esc_attr__( 'Specify what from time of the day to show the menu', 'side-menu' ),
);

$time_end = array(
	'name' => 'param[time_end]',
	'id'   => 'time_end',
	'val'  => isset( $param['time_end'] ) ? $param['time_end'] : '23:59',
	'type' => 'time',
);

$time_end_help = array(
	'text' => esc_attr__( 'Specify what to time of the day to show the menu', 'side-menu' ),
);

$count_weekday = ( ! empty( $param['weekday_arr'] ) ) ? count( $param['weekday_arr'] ) : '0';

if($count_weekday > 0) {
	for ( $i = 0; $i < $count_weekday; $i ++ ) {
		$weekday_[ $i ] = array(
			'name'    => 'param[weekday_arr][]',
			'type'    => 'select',
			'val'     => isset( $param['weekday_arr'][ $i ] ) ? $param['weekday_arr'][ $i ] : 'none',
			'option'  => [
				'none' => esc_attr__( 'Everyday', 'side-menu' ),
				'1'    => esc_attr__( 'Monday', 'side-menu' ),
				'2'    => esc_attr__( 'Tuesday', 'side-menu' ),
				'3'    => esc_attr__( 'Wednesday', 'side-menu' ),
				'4'    => esc_attr__( 'Thursday', 'side-menu' ),
				'5'    => esc_attr__( 'Friday', 'side-menu' ),
				'6'    => esc_attr__( 'Saturday', 'side-menu' ),
				'7'    => esc_attr__( 'Sunday ', 'side-menu' ),

			],
			'tooltip' => esc_attr__( 'Select the day of the week when the notification will be displayed.',
				'side-menu' ),
			'icon'    => '',
			'func'    => '',
		);

		$time_start_[ $i ] = array(
			'name' => 'param[time_start_arr][]',
			'type' => 'time',
			'val'  => isset( $param['time_start_arr'][ $i ] ) ? $param['time_start_arr'][ $i ] : '00:00',
		);

		$time_end_[ $i ] = array(
			'name' => 'param[time_end_arr][]',
			'val'  => isset( $param['time_end_arr'][ $i ] ) ? $param['time_end_arr'][ $i ] : '23:59',
			'type' => 'time',
		);
	}
}

$set_dates = array(
	'name' => 'param[set_dates]',
	'id'   => 'set_dates',
	'val'  => isset( $param['set_dates'] ) ? $param['set_dates'] : '',
	'type' => 'checkbox',
);

$set_dates_help = array(
	'text' => esc_attr__( 'Check this if you want to set the show menu between dates.', 'side-menu' ),
);

$date_start = array(
	'name' => 'param[date_start]',
	'id'   => 'date_start',
	'val'  => isset( $param['date_start'] ) ? $param['date_start'] : '',
	'type' => 'date',
	'class' => 'input',
);

$date_start_help = array(
	'text' => esc_attr__( 'Set the date start.', 'side-menu' ),
);

$date_end = array(
	'name'  => 'param[date_end]',
	'id'    => 'date_end',
	'val'   => isset( $param['date_end'] ) ? $param['date_end'] : '',
	'type'  => 'date',
	'class' => 'input',
);

$date_start_help = array(
	'text' => esc_attr__( 'Set the date end.', 'side-menu' ),
);

//endregion

//region Browser

$all_browser = array(
	'name' => 'param[all_browser]',
	'id'   => 'all_browser',
	'val'  => isset( $param['all_browser'] ) ? $param['all_browser'] : '0',
	'type' => 'checkbox'
);

$br_opera = array(
	'name' => 'param[br_opera]',
	'id'   => 'br_opera',
	'val'  => isset( $param['br_opera'] ) ? $param['br_opera'] : '0',
	'type' => 'checkbox'
);

$br_edge = array(
	'name'  => 'param[br_edge]',
	'id'    => 'br_edge',
	'val'   => isset( $param['br_edge'] ) ? $param['br_edge'] : '0',
	'class' => 'browser',
	'type'  => 'checkbox'
);

$br_chrome = array(
	'name'  => 'param[br_chrome]',
	'id'    => 'br_chrome',
	'val'   => isset( $param['br_chrome'] ) ? $param['br_chrome'] : '0',
	'class' => 'browser',
	'type'  => 'checkbox'
);

$br_safari = array(
	'name'  => 'param[br_safari]',
	'id'    => 'br_safari',
	'val'   => isset( $param['br_safari'] ) ? $param['br_safari'] : '0',
	'class' => 'browser',
	'type'  => 'checkbox'
);

$br_firefox = array(
	'name'  => 'param[br_firefox]',
	'id'    => 'br_firefox',
	'val'   => isset( $param['br_firefox'] ) ? $param['br_firefox'] : '0',
	'class' => 'browser',
	'type'  => 'checkbox'

);

$br_ie = array(
	'name'  => 'param[br_ie]',
	'id'    => 'br_ie',
	'val'   => isset( $param['br_ie'] ) ? $param['br_ie'] : '0',
	'class' => 'browser',
	'type'  => 'checkbox'
);

$br_other = array(
	'name' => 'param[br_other]',
	'id'   => 'br_other',
	'val'  => isset( $param['br_other'] ) ? $param['br_other'] : '0',
	'type' => 'checkbox'
);

//endregion