<?php
/**
 * Clone Elements Settings
 *
 * @package     Wow_Plugin
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

// Elements for clone Menu 1
$menu_1_item_icon        = array(
	'name'   => 'param[menu_1][item_icon][]',
	'class'  => 'icons',
	'type'   => 'select',
	'val'    => 'fas fa-hand-point-up',
	'option' => $icons_new,
);

$menu_1_item_icon_anomate = array(
	'name'   => 'param[menu_1][item_icon_anomate][]',
	'type'   => 'select',
	'val'    =>  '',
	'option' => [
		'' => __('None', 'side-menu'),
		'fa-beat' => __('Beat', 'side-menu'),
		'fa-fade' => __('Fade', 'side-menu'),
		'fa-beat-fade' => __('Beat-Fade', 'side-menu'),
		'fa-bounce' => __('Bounce', 'side-menu'),
		'fa-flip' => __('Flip', 'side-menu'),
		'fa-shake' => __('Shake', 'side-menu'),
		'fa-spin' => __('Spin', 'side-menu'),
	],
);

$menu_1_item_custom      = array(
	'name'  => 'param[menu_1][item_custom][]',
	'type'  => 'checkbox',
	'class' => 'custom-icon',
	'val'   => 0,
	'func'  => 'customicon(this); checkboxchecked(this);',
);
$menu_1_item_custom_link = array(
	'name'   => 'param[menu_1][item_custom_link][]',
	'type'   => 'text',
	'class'  => 'custom-icon-url',
	'val'    => '',
	'option' => array(
		'placeholder' => esc_attr__( 'Enter Icon URL', 'side-menu' ),
	),
);

$menu_1_image_alt = array(
	'name' => 'param[menu_1][image_alt][]',
	'type' => 'text',
	'val'  => '',
);

$menu_1_image_alt_help = array(
	'title' => esc_attr__( 'Image Alt', 'side-menu' ),
	'ul'    => array(
		esc_attr__( 'Set the attribute Alt for custom image.', 'side-menu' ),
	)
);

$menu_1_item_custom_text_check = array(
	'name'  => 'param[menu_1][item_custom_text_check][]',
	'type'  => 'checkbox',
	'class' => 'custom-icon-text',
	'val'   => '',
);

// Custom icon URL
$menu_1_item_custom_text = array(
	'name'   => 'param[menu_1][item_custom_text][]',
	'type'   => 'text',
	'val'    => '',
	'class'  => 'icon-custom-text',
);

$menu_1_item_custom_text_check_help = array(
	'text' => esc_attr__( 'You can set the Emoji, Glyphs or Leter.', 'side-menu' ),
);

$menu_1_item_tooltip     = array(
	'name'  => 'param[menu_1][item_tooltip][]',
	'class' => 'item-tooltip',
	'type'  => 'text',
	'val'   => '',
);

$menu_1_item_type = array(
	'name'   => 'param[menu_1][item_type][]',
	'type'   => 'select',
	'val'    => 'link',
	'class'  => 'item-type',
	'option' => array(
		'link'         => esc_attr__( 'Link', 'side-menu' ),
		'share'        => esc_attr__( 'Share', 'side-menu' ),
		'translate'    => esc_attr__( 'Translate', 'side-menu' ),
		'next_post'     => esc_attr__( 'Next Post', 'side-menu' ),
		'previous_post' => esc_attr__( 'Previous Post', 'side-menu' ),
		'search'       => esc_attr__( 'Search', 'side-menu' ),
		'print'        => esc_attr__( 'Print', 'side-menu' ),
		'totop'        => esc_attr__( 'Scroll to Top', 'side-menu' ),
		'tobottom'     => esc_attr__( 'Scroll to Bottom', 'side-menu' ),
		'smoothscroll' => esc_attr__( 'Smooth Scroll', 'side-menu' ),
		'scrollSpy'     => esc_attr__( 'Scrollspy', 'side-menu' ),
		'goback'       => esc_attr__( 'Go Back', 'side-menu' ),
		'goforward'    => esc_attr__( 'Go Forward', 'side-menu' ),
		'email'        => esc_attr__( 'Email', 'side-menu' ),
		'telephone'    => esc_attr__( 'Telephone', 'side-menu' ),
		'login'        => esc_attr__( 'Login', 'side-menu' ),
		'logout'       => esc_attr__( 'Logout', 'side-menu' ),
		'register'     => esc_attr__( 'Register', 'side-menu' ),
		'lostpassword' => esc_attr__( 'Lostpassword', 'side-menu' ),
		'id'           => esc_attr__( 'Item only with ID', 'side-menu' ),
		'class'        => esc_attr__( 'Item only with Class', 'side-menu' ),
		'modal'        => esc_attr__( 'Open Modal Window', 'side-menu' ),
		'shiftnav'     => esc_attr__( 'ShiftNav Menu', 'side-menu' ),
	),
	'func'   => 'itemtype(this);',
);

$menu_1_item_link = array(
	'name' => 'param[menu_1][item_link][]',
	'type' => 'text',
	'val'  => '',
);

$menu_1_new_tab = array(
	'name'  => 'param[menu_1][new_tab][]',
	'class' => '',
	'type'  => 'checkbox',
	'val'   => '',
);

$menu_1_item_share = array(
	'name'   => 'param[menu_1][item_share][]',
	'type'   => 'select',
	'val'    => 'Facebook',
	'option' => array(
		'Facebook'         => esc_attr__( 'Facebook', 'side-menu' ),
		'VK'               => esc_attr__( 'VK', 'side-menu' ),
		'Twitter'          => esc_attr__( 'Twitter', 'side-menu' ),
		'Linkedin'         => esc_attr__( 'Linkedin', 'side-menu' ),
		'Odnoklassniki'    => esc_attr__( 'Odnoklassniki', 'side-menu' ),
		'Google'           => esc_attr__( 'Google', 'side-menu' ),
		'Pinterest'        => esc_attr__( 'Pinterest', 'side-menu' ),
		'xing'             => esc_attr__( 'XING', 'side-menu' ),
		'myspace'          => esc_attr__( 'Myspace', 'side-menu' ),
		'weibo'            => esc_attr__( 'Weibo', 'side-menu' ),
		'buffer'           => esc_attr__( 'Buffer', 'side-menu' ),
		'stumbleupon'      => esc_attr__( 'StumbleUpon', 'side-menu' ),
		'reddit'           => esc_attr__( 'Reddit', 'side-menu' ),
		'tumblr'           => esc_attr__( 'Tumblr', 'side-menu' ),
		'blogger'          => esc_attr__( 'Blogger', 'side-menu' ),
		'livejournal'      => esc_attr__( 'LiveJournal', 'side-menu' ),
		'pocket'           => esc_attr__( 'Pocket', 'side-menu' ),
		'telegram'         => esc_attr__( 'Telegram', 'side-menu' ),
		'skype'            => esc_attr__( 'Skype', 'side-menu' ),
		'email'            => esc_attr__( 'Email', 'side-menu' ),
		'draugiem'         => esc_attr__( 'Draugiem', 'side-menu' ),
		'whatsapp'         => esc_attr__( 'Whatsapp', 'side-menu' ),
		'diaspora'         => esc_attr__( 'Diaspora', 'side-menu' ),
		'digg'             => esc_attr__( 'Digg', 'side-menu' ),
		'douban'           => esc_attr__( 'Douban', 'side-menu' ),
		'evernote'         => esc_attr__( 'Evernote', 'side-menu' ),
		'flipboard'        => esc_attr__( 'Flipboard', 'side-menu' ),
		'google-bookmarks' => esc_attr__( 'Google Bookmarks', 'side-menu' ),
		'hacker-news'      => esc_attr__( 'Hacker News', 'side-menu' ),
		'instapaper'       => esc_attr__( 'Instapaper', 'side-menu' ),
		'line'             => esc_attr__( 'Line', 'side-menu' ),
		'qzone'            => esc_attr__( 'Qzone', 'side-menu' ),
		'renren'           => esc_attr__( 'Renren', 'side-menu' ),
	),
	'func'   => '',
);

$menu_1_item_gtranslate = array(
	'name'   => 'param[menu_1][gtranslate][]',
	'type'   => 'select',
	'val'    => '',
	'class'  => 'gtranslate',
	'option' => array(
		'af'  => esc_attr__( 'Afrikaans', 'side-menu' ),
		'sq'  => esc_attr__( 'Albanian', 'side-menu' ),
		'am'  => esc_attr__( 'Amharic', 'side-menu' ),
		'ar'  => esc_attr__( 'Arabic', 'side-menu' ),
		'hy'  => esc_attr__( 'Armenian', 'side-menu' ),
		'az'  => esc_attr__( 'Azerbaijani', 'side-menu' ),
		'eu'  => esc_attr__( 'Basque', 'side-menu' ),
		'be'  => esc_attr__( 'Belarusian', 'side-menu' ),
		'bn'  => esc_attr__( 'Bengali', 'side-menu' ),
		'bs'  => esc_attr__( 'Bosnian', 'side-menu' ),
		'bg'  => esc_attr__( 'Bulgarian', 'side-menu' ),
		'ca'  => esc_attr__( 'Catalan', 'side-menu' ),
		'ceb' => esc_attr__( 'Cebuano', 'side-menu' ),
		'ny'  => esc_attr__( 'Chichewa', 'side-menu' ),
		'co'  => esc_attr__( 'Corsican', 'side-menu' ),
		'hr'  => esc_attr__( 'Croatian', 'side-menu' ),
		'cs'  => esc_attr__( 'Czech', 'side-menu' ),
		'da'  => esc_attr__( 'Danish', 'side-menu' ),
		'nl'  => esc_attr__( 'Dutch', 'side-menu' ),
		'en'  => esc_attr__( 'English', 'side-menu' ),
		'eo'  => esc_attr__( 'Esperanto', 'side-menu' ),
		'et'  => esc_attr__( 'Estonian', 'side-menu' ),
		'tl'  => esc_attr__( 'Filipino', 'side-menu' ),
		'fi'  => esc_attr__( 'Finnish', 'side-menu' ),
		'fr'  => esc_attr__( 'French', 'side-menu' ),
		'fy'  => esc_attr__( 'Frisian', 'side-menu' ),
		'gl'  => esc_attr__( 'Galician', 'side-menu' ),
		'ka'  => esc_attr__( 'Georgian', 'side-menu' ),
		'de'  => esc_attr__( 'German', 'side-menu' ),
		'el'  => esc_attr__( 'Greek', 'side-menu' ),
		'gu'  => esc_attr__( 'Gujarati', 'side-menu' ),
		'ht'  => esc_attr__( 'Haitian Creole', 'side-menu' ),
		'ha'  => esc_attr__( 'Hausa', 'side-menu' ),
		'haw' => esc_attr__( 'Hawaiian', 'side-menu' ),
		'iw'  => esc_attr__( 'Hebrew', 'side-menu' ),
		'hi'  => esc_attr__( 'Hindi', 'side-menu' ),
		'hmn' => esc_attr__( 'Hmong', 'side-menu' ),
		'hu'  => esc_attr__( 'Hungarian', 'side-menu' ),
		'is'  => esc_attr__( 'Icelandic', 'side-menu' ),
		'ig'  => esc_attr__( 'Igbo', 'side-menu' ),
		'id'  => esc_attr__( 'Indonesian', 'side-menu' ),
		'ga'  => esc_attr__( 'Irish', 'side-menu' ),
		'it'  => esc_attr__( 'Italian', 'side-menu' ),
		'ja'  => esc_attr__( 'Japanese', 'side-menu' ),
		'jw'  => esc_attr__( 'Javanese', 'side-menu' ),
		'kn'  => esc_attr__( 'Kannada', 'side-menu' ),
		'kk'  => esc_attr__( 'Kazakh', 'side-menu' ),
		'km'  => esc_attr__( 'Khmer', 'side-menu' ),
		'ko'  => esc_attr__( 'Korean', 'side-menu' ),
		'ku'  => esc_attr__( 'Kurdish (Kurmanji)', 'side-menu' ),
		'ky'  => esc_attr__( 'Kyrgyz', 'side-menu' ),
		'lo'  => esc_attr__( 'Lao', 'side-menu' ),
		'la'  => esc_attr__( 'Latin', 'side-menu' ),
		'lv'  => esc_attr__( 'Latvian', 'side-menu' ),
		'lb'  => esc_attr__( 'Luxembourgish', 'side-menu' ),
		'mk'  => esc_attr__( 'Macedonian', 'side-menu' ),
		'mg'  => esc_attr__( 'Malagasy', 'side-menu' ),
		'ms'  => esc_attr__( 'Malay', 'side-menu' ),
		'ml'  => esc_attr__( 'Malayalam', 'side-menu' ),
		'mt'  => esc_attr__( 'Maltese', 'side-menu' ),
		'mi'  => esc_attr__( 'Maori', 'side-menu' ),
		'mr'  => esc_attr__( 'Marathi', 'side-menu' ),
		'mn'  => esc_attr__( 'Mongolian', 'side-menu' ),
		'my'  => esc_attr__( 'Myanmar (Burmese)', 'side-menu' ),
		'ne'  => esc_attr__( 'Nepali', 'side-menu' ),
		'no'  => esc_attr__( 'Norwegian', 'side-menu' ),
		'ps'  => esc_attr__( 'Pashto', 'side-menu' ),
		'fa'  => esc_attr__( 'Persian', 'side-menu' ),
		'pl'  => esc_attr__( 'Polish', 'side-menu' ),
		'pt'  => esc_attr__( 'Portuguese', 'side-menu' ),
		'pa'  => esc_attr__( 'Punjabi', 'side-menu' ),
		'ro'  => esc_attr__( 'Romanian', 'side-menu' ),
		'ru'  => esc_attr__( 'Russian', 'side-menu' ),
		'sm'  => esc_attr__( 'Samoan', 'side-menu' ),
		'gd'  => esc_attr__( 'Scottish Gaelic', 'side-menu' ),
		'sr'  => esc_attr__( 'Serbian', 'side-menu' ),
		'st'  => esc_attr__( 'Sesotho', 'side-menu' ),
		'sn'  => esc_attr__( 'Shona', 'side-menu' ),
		'sd'  => esc_attr__( 'Sindhi', 'side-menu' ),
		'si'  => esc_attr__( 'Sinhala', 'side-menu' ),
		'sk'  => esc_attr__( 'Slovak', 'side-menu' ),
		'sl'  => esc_attr__( 'Slovenian', 'side-menu' ),
		'so'  => esc_attr__( 'Somali', 'side-menu' ),
		'es'  => esc_attr__( 'Spanish', 'side-menu' ),
		'su'  => esc_attr__( 'Sudanese', 'side-menu' ),
		'sw'  => esc_attr__( 'Swahili', 'side-menu' ),
		'sv'  => esc_attr__( 'Swedish', 'side-menu' ),
		'tg'  => esc_attr__( 'Tajik', 'side-menu' ),
		'ta'  => esc_attr__( 'Tamil', 'side-menu' ),
		'te'  => esc_attr__( 'Telugu', 'side-menu' ),
		'th'  => esc_attr__( 'Thai', 'side-menu' ),
		'tr'  => esc_attr__( 'Turkish', 'side-menu' ),
		'uk'  => esc_attr__( 'Ukrainian', 'side-menu' ),
		'ur'  => esc_attr__( 'Urdu', 'side-menu' ),
		'uz'  => esc_attr__( 'Uzbek', 'side-menu' ),
		'vi'  => esc_attr__( 'Vietnamese', 'side-menu' ),
		'cy'  => esc_attr__( 'Welsh', 'side-menu' ),
		'xh'  => esc_attr__( 'Xhosa', 'side-menu' ),
		'yi'  => esc_attr__( 'Yiddish', 'side-menu' ),
		'yo'  => esc_attr__( 'Yoruba', 'side-menu' ),
		'zu'  => esc_attr__( 'Zulu', 'side-menu' ),
	),
	'func'   => '',
);

$menu_1_item_modal = array(
	'name' => 'param[menu_1][item_modal][]',
	'type' => 'text',
	'val'  => '',
);


// Font color
$menu_1_color = array(
	'name' => 'param[menu_1][color][]',
	'type' => 'color',
	'val'  => '#ffffff',
);

// Icon Сolor
$menu_1_iconcolor = array(
	'name' => 'param[menu_1][iconcolor][]',
	'type' => 'color',
	'val'  => '#ffffff',
);

// Background
$menu_1_bcolor = array(
	'name' => 'param[menu_1][bcolor][]',
	'type' => 'color',
	'val'  => '#128be0',
);

// Background Hover
$menu_1_hbcolor = array(
	'name' => 'param[menu_1][hbcolor][]',
	'type' => 'color',
	'val'  => '#128be0',
);

$menu_1_button_id = array(
	'name' => 'param[menu_1][button_id][]',
	'type' => 'text',
	'val'  => '',
);

$menu_1_button_id_help = array(
	'text' => esc_attr__( 'Set ID for element.', 'side-menu' ),
);

$menu_1_button_class = array(
	'name' => 'param[menu_1][button_class][]',
	'type' => 'text',
	'val'  => '',
);

$menu_1_button_class_help = array(
	'title' => esc_attr__( 'Set Class for element.', 'side-menu' ),
	'ul'    => array(
		__( 'You may enter several classes separated by a space.', 'side-menu' ),
	)
);

$menu_1_link_rel = array(
	'name' => 'param[menu_1][link_rel][]',
	'type' => 'text',
	'val'  => '',
);

$menu_1_hold_open = array(
	'name'  => 'param[menu_1][hold_open][]',
	'class' => '',
	'type'  => 'checkbox',
	'val'   => '',
);

$menu_1_sub_item = array(
	'name'  => 'param[menu_1][sub_item][]',
	'class' => 'sub-item',
	'type'  => 'checkbox',
	'val'   => '',
);

$menu_1_close_item = array(
	'name' => 'param[menu_1][close_item][]',
	'type' => 'number',
	'val'   => '',
	'option' => array(
		'min' => '0'
	),
);

// Extra text
$menu_1_item_text = array(
	'name'  => 'param[menu_1][item_text][]',
	'class' => '',
	'id'    => 'item_extra_text',
	'type'  => 'shorteditor',
	'val'   => '',
);

$menu_1_item_text_size = array(
	'name' => 'param[menu_1][item_text_size][]',
	'type' => 'number',
	'val'  => '16',
);

$menu_1_item_text_width = array(
	'name'  => 'param[menu_1][item_text_width][]',
	'class' => '',
	'type'  => 'number',
	'val'   => '270',
);

$menu_1_item_icon_help = array(
	'title' => esc_attr__( 'Set the icon for menu item. If you want use the custom item:', 'side-menu' ),
	'ul'    => array(
		esc_attr__( '1. Check the box on "custom"', 'side-menu' ),
		esc_attr__( '2. Upload the icon in Media Library', 'side-menu' ),
		esc_attr__( '3. Copy the URL to icon', 'side-menu' ),
		esc_attr__( '4. Paste the icon URL to field', 'side-menu' ),
	),
);

$menu_1_item_tooltip_help = array(
	'text' => esc_attr__( 'Set the text for menu item.', 'side-menu' ),
);

$menu_1_item_type_help = array(
	'text' => esc_attr__( 'Select the type of menu item. Explanation of some types:', 'side-menu' ),
	'ul'   => array(
		esc_attr__( '<strong>Smooth Scroll</strong> - Smooth scrolling of the page to the specified anchors on the page.', 'side-menu' ),
		esc_attr__( '<strong>ShiftNav Menu</strong> - open the menu, wich create via the plugin ShiftNav.', 'side-menu' ),
	),
);

$menu_1_hold_open_help = array(
	'text' => esc_attr__( 'When the page loads, the menu item will open.', 'side-menu' ),
);

$menu_1_close_item_help = array(
	'text' => esc_attr__( 'Set the value in seconds after how long it is necessary to close the item. Leave the field empty or with a value of 0 for not to close the item.', 'side-menu' ),
);