<?php
/**
 * Main Settings
 *
 * @package     Wow_Plugin
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
include_once( 'options/main.php' );

?>

<fieldset>
    <legend>
        <i class="set-icon fa-solid fa-sliders"></i>
		<?php esc_html_e( 'General', 'side-menu' ); ?>
    </legend>

<div class="columns is-multiline has-borderbox">
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Position', 'side-menu' ); ?><?php echo self::tooltip( $menu_help ); ?>
            </label>
			<?php self::option( $menu ); ?>
        </div>

    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Vertical alignment', 'side-menu' ); ?><?php echo self::tooltip( $align_help ); ?>
            </label>
			<?php self::option( $align ); ?>
        </div>
    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Offset', 'side-menu' ); ?><?php echo self::tooltip( $margin_help ); ?>
            </label>
            <div class="field has-addons">
				<?php self::option( $margin ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>
        </div>
    </div>


    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Space between items', 'side-menu' ); ?><?php echo self::tooltip( $gap_help ); ?>
            </label>
            <div class="field has-addons">
				<?php self::option( $gap ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>
        </div>
    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Shadow', 'side-menu' ); ?><?php echo self::tooltip( $shadow_help ); ?>
            </label>
			<?php self::option( $shadow ); ?>
        </div>
    </div>


    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Font style', 'side-menu' ); ?>
            </label>
			<?php self::option( $fontstyle ); ?>
        </div>
    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Font weight', 'side-menu' ); ?>
            </label>
			<?php self::option( $fontweight ); ?>
        </div>
    </div>


    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Z-index', 'side-menu' ); ?><?php echo self::tooltip( $zindex_help ); ?>
            </label>
			<?php self::option( $zindex ); ?>
        </div>
    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Border width', 'side-menu' ); ?><?php echo self::tooltip( $bwidth_help ); ?>
            </label>
            <div class="field has-addons">
				<?php self::option( $bwidth ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>
        </div>
    </div>

    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Top border radius', 'side-menu' ); ?><?php echo self::tooltip( $bradiustop_help ); ?>
            </label>
            <div class="field has-addons">
				<?php self::option( $bradiustop ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>

        </div>
    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Bottom border radius', 'side-menu' ); ?><?php echo self::tooltip( $bradiusbottom_help ); ?>
            </label>
            <div class="field has-addons">
				<?php self::option( $bradiusbottom ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>
        </div>
    </div>
    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Border color', 'side-menu' ); ?><?php echo self::tooltip( $bcolor_help ); ?>
            </label>
			<?php self::option( $bcolor ); ?>
        </div>
    </div>

    <div class="column is-4">
        <div class="field">
            <label class="label">
				<?php esc_attr_e( 'Connect all Items', 'side-menu' ); ?><?php echo self::tooltip( $connect_help ); ?>
            </label>
			<?php self::option( $connect ); ?>
        </div>
    </div>
    <div class="column is-4 hold-open">
        <div class="field">
            <label class="label">
				<?php self::option( $hold_open ); ?><?php esc_attr_e( 'Hold open', 'side-menu' ); ?>
            </label>
        </div>

    </div>

</div>
</fieldset>
<fieldset>
    <legend>
        <i class="set-icon fa-solid fa-toggle-off"></i>
        <?php esc_html_e( 'Show/Hide', 'side-menu' ); ?>
    </legend>

    <div class="columns is-multiline has-borderbox">

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Show after Position', 'side-menu' ); ?><?php echo self::tooltip( $showAfterPosition_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $showAfterPosition ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>

            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Hide after Position', 'side-menu' ); ?><?php echo self::tooltip( $hideAfterPosition_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $hideAfterPosition ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Timer for display', 'side-menu' ); ?><?php echo self::tooltip( $showAfterTimer_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $showAfterTimer ); ?>
                    <div class="control">
                        <span class="addon">sec</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Timer for hide', 'side-menu' ); ?><?php echo self::tooltip( $hideAfterTimer_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $hideAfterTimer ); ?>
                    <div class="control">
                        <span class="addon">sec</span>
                    </div>
                </div>
            </div>
        </div>

    </div>

</fieldset>


<fieldset>
    <legend>
        <i class="set-icon fa-solid fa-text-height"></i>
        <?php esc_html_e( 'Size', 'side-menu' ); ?></legend>
    <div class="columns is-multiline has-borderbox">
        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Item Height', 'side-menu' ); ?><?php echo self::tooltip( $height_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $height ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Icon size', 'side-menu' ); ?><?php echo self::tooltip( $iconsize_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $iconsize ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Font size', 'side-menu' ); ?><?php echo self::tooltip( $fontsize_help ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $fontsize ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

    </div>

</fieldset>

<fieldset>
    <legend>
        <i class="set-icon fa-solid fa-mobile-screen"></i>
        <?php esc_html_e( 'Mobile size', 'side-menu' ); ?>
    </legend>
    <div class="columns is-multiline has-borderbox">
        <div class="column is-6">
            <div class="field">
                <label class="label">
					<?php self::option( $mobile ); ?><?php esc_attr_e( 'Enable settings on mobile devices', 'side-menu' ); ?>
                </label>

            </div>
        </div>


        <div class="column is-6">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Mobile screen', 'side-menu' ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $m_screen ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>


        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Item Height', 'side-menu' ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $m_height ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Icon size', 'side-menu' ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $m_iconsize ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
					<?php esc_attr_e( 'Font size', 'side-menu' ); ?>
                </label>
                <div class="field has-addons">
					<?php self::option( $m_fontsize ); ?>
                    <div class="control">
                        <span class="addon">px</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="column is-4">
            <div class="field">
                <label class="label">
	                <?php self::option( $deactivateMobileRule ); ?>
				    <?php esc_attr_e( 'Deactivate touch rule', 'side-menu' ); ?>
                </label>
            </div>
        </div>

    </div>
</fieldset>

