<?php

/**
 * Display
 *
 * @package     Wow_Pluign
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
include_once( 'options/display.php' );

?>
<fieldset class="itembox">
    <legend>
        <span class="set-icon fa-solid fa-laptop"></span>
		<?php
		esc_attr_e( 'Show on devices', 'side-menu' ); ?>
    </legend>
    <div class="columns is-multiline has-borderbox">

        <div class="column is-6">
            <label class="checkbox label checkLabel">
				<?php
				self::option( $include_more_screen ); ?><?php
				esc_attr_e( "Don't show on screens more", 'side-menu' ); ?><?php
				self::tooltip( $show_screen_help ); ?>
            </label>
            <div class="field has-addons">
				<?php
				self::option( $screen_more ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>
        </div>

        <div class="column is-6">
            <label class="checkbox label checkLabel">
				<?php
				self::option( $include_mobile ); ?><?php
				esc_attr_e( "Don't show on screens less", 'side-menu' ); ?><?php
				self::tooltip( $include_mobile_help ); ?>
            </label>
            <div class="field has-addons">
				<?php
				self::option( $screen ); ?>
                <div class="control">
                    <span class="addon">px</span>
                </div>
            </div>
        </div>

    </div>
</fieldset>

<fieldset class="itembox">
    <legend>
        <i class="set-icon fa-solid fa-users"></i>
		<?php
		esc_attr_e( 'Show for users', 'side-menu' ); ?>
    </legend>
    <div class="columns is-multiline has-borderbox">
        <div class="column is-4">
			<?php
			self::option( $item_user ); ?>
        </div>
        <div class="column is-4 is-visibile-hidden item-user">

			<?php
			if ( is_array( $users_arr ) ) {
				$old_check = isset( $param['user_role'] ) ? $param['user_role'] : '';
				foreach ( $users_arr as $key => $value ) {
					$checked = ! empty( $param['user_role'][ $key ] ) ? 1 : 0;
					if ( $old_check === $key ) {
						$checked = 1;
					}
					?>
                    <label class="checkbox label">
                        <input type="checkbox" name="param[user_role][<?php
						echo esc_attr( $key ); ?>]" id="sm_user_<?php
						echo esc_attr( $key ); ?>" class=""<?php
						checked( $checked, 1 ); ?>> <?php
						echo esc_attr( $value ); ?>
                    </label>

					<?php
				}
			}


			?>

        </div>
    </div>
</fieldset>

<fieldset class="itembox">
    <legend>
        <i class="set-icon fa-solid fa-language"></i>
		<?php
		esc_attr_e( 'Depending on the language', 'side-menu' ); ?>
    </legend>
    <div class="columns is-multiline has-borderbox">
        <div class="column is-4">
            <label class="checkbox label checkLabel">
				<?php
				self::option( $depending_language ); ?><?php
				esc_attr_e( "Enable", 'side-menu' ); ?>
            </label>
            <div class="field">
				<?php
				self::option( $lang ); ?>
            </div>
        </div>
    </div>
</fieldset>

<fieldset class="itembox">
    <legend>
        <i class="set-icon fa-solid fa-font-awesome"></i>
		<?php
		esc_attr_e( 'Font Awesome 6 style', 'side-menu' ); ?>
    </legend>
    <div class="columns is-multiline has-borderbox">
        <div class="column is-4">
            <label class="checkbox label">
				<?php
				self::option( $disable_fontawesome ); ?><?php
				esc_attr_e( "Disable", 'side-menu' ); ?><?php
				self::tooltip( $disable_fontawesome_help ); ?>
            </label>
        </div>
    </div>
</fieldset>

<fieldset class="itembox">
    <legend>
        <i class="set-icon fa-solid fa-calendar-days"></i>
		<?php
		esc_attr_e( 'Schedule', 'side-menu' ); ?>
    </legend>
    <div class="has-borderbox">

        <div id="schedule">

            <div class="columns is-multiline">
                <div class="column is-4">
                    <div class="field">
                        <label class="label">
							<?php
							esc_attr_e( 'Day of the week', 'side-menu' ); ?><?php
							self::tooltip( $weekday_help ); ?>
                        </label>
						<?php
						self::option( $weekday ); ?>
                    </div>
                </div>
                <div class="column is-4">
                    <div class="field">
                        <label class="label">
							<?php
							esc_attr_e( 'Time from', 'side-menu' ); ?><?php
							self::tooltip( $time_start_help ); ?>
                        </label>
						<?php
						self::option( $time_start ); ?>
                    </div>
                </div>
                <div class="column is-4">
                    <div class="field">
                        <label class="label">
							<?php
							esc_attr_e( 'Time to', 'side-menu' ); ?><?php
							self::tooltip( $time_end_help ); ?>
                        </label>
						<?php
						self::option( $time_end ); ?>
                    </div>
                </div>
            </div>

			<?php
			if ( $count_weekday > 0 ) : ?>

				<?php
				for ( $i = 0; $i < $count_weekday; $i ++ ) : ?>
                    <div class="columns is-multiline">
                        <div class="column">
                            <div class="field">
                                <label class="label">
									<?php
									esc_attr_e( 'Day of the week', 'side-menu' ); ?><?php
									self::tooltip( $weekday_help ); ?>
                                </label>
								<?php
								self::option( $weekday_[ $i ] ); ?>
                            </div>
                        </div>
                        <div class="column ">
                            <div class="field">
                                <label class="label">
									<?php
									esc_attr_e( 'Time from', 'side-menu' ); ?><?php
									self::tooltip( $time_start_help ); ?>
                                </label>
								<?php
								self::option( $time_start_[ $i ] ); ?>
                            </div>
                        </div>
                        <div class="column">
                            <div class="field">
                                <label class="label">
									<?php
									esc_attr_e( 'Time to', 'side-menu' ); ?><?php
									self::tooltip( $time_end_help ); ?>
                                </label>
								<?php
								self::option( $time_end_[ $i ] ); ?>
                            </div>
                        </div>
                    </div>


				<?php
				endfor; ?><?php
			endif; ?>
        </div>

        <div class="columns">

            <div class="column is-12 btn-add-day">
                <button class="button button-primary" type="button" id="add-day">
					<?php
					esc_attr_e( 'Add Day', 'side-menu' ); ?>
                </button>

                <button class="button" type="button" id="remove-day">
					<?php
					esc_attr_e( 'Remove Last Day', 'side-menu' ); ?>
                </button>
            </div>
        </div>

        <div class="columns is-multiline">
            <div class="column is-4">
                <label class="checkbox label checkBlock">
					<?php
					self::option( $set_dates ); ?><?php
					esc_attr_e( "Set Dates", 'side-menu' ); ?><?php
					self::tooltip( $set_dates_help ); ?>
                </label>

            </div>

            <div class="column is-4 blockHidden is-hidden">
                <div class="field">
                    <label class="label">
						<?php
						esc_attr_e( 'Date Start', 'side-menu' ); ?><?php
						self::tooltip( $date_start_help ); ?>
                    </label>
					<?php
					self::option( $date_start ); ?>
                </div>
            </div>

            <div class="column is-4 blockHidden is-hidden">
                <div class="field">
                    <label class="label">
						<?php
						esc_attr_e( 'Date End', 'side-menu' ); ?><?php
						self::tooltip( $date_start_help ); ?>
                    </label>
					<?php
					self::option( $date_end ); ?>
                </div>
            </div>
        </div>
    </div>
</fieldset>

<fieldset class="itembox">
    <legend>
        <i class="set-icon fa-solid fa-globe"></i>
		<?php
		esc_attr_e( 'User Browser', 'side-menu' ); ?>
    </legend>

    <div class="columns is-multiline has-borderbox">
        <div class="column is-12">
            <label class="checkbox label checkBlock">
				<?php
				self::option( $all_browser ); ?><?php
				esc_attr_e( "Enable browser dependency", 'side-menu' ); ?>
            </label>
        </div>
        <div class="column is-12 blockHidden">
            <label class="checkbox label">
				<?php
				self::option( $br_opera ); ?><?php
				esc_attr_e( "Don't show in Opera", 'side-menu' ); ?>
            </label>
            <label class="checkbox label">
				<?php
				self::option( $br_edge ); ?><?php
				esc_attr_e( "Don't show in Microsoft Edge", 'side-menu' ); ?>
            </label>
            <label class="checkbox label">
				<?php
				self::option( $br_chrome ); ?><?php
				esc_attr_e( "Don't show in Chrome", 'side-menu' ); ?>
            </label>
            <label class="checkbox label">
				<?php
				self::option( $br_safari ); ?><?php
				esc_attr_e( "Don't show in Safari", 'side-menu' ); ?>
            </label>
            <label class="checkbox label">
				<?php
				self::option( $br_firefox ); ?><?php
				esc_attr_e( "Don't show in Firefox", 'side-menu' ); ?>
            </label>
            <label class="checkbox label">
				<?php
				self::option( $br_ie ); ?><?php
				esc_attr_e( "Don't show in Internet Explorer", 'side-menu' ); ?>
            </label>
            <label class="checkbox label">
				<?php
				self::option( $br_other ); ?><?php
				esc_attr_e( "Don't show in Other", 'side-menu' ); ?>
            </label>

        </div>

    </div>

</fieldset>