<?php
/**
 * Elements for clone
 *
 * @package     Wow_Plugin
 * @copyright   Copyright (c) 2018, Dmytro Lobov
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

include_once( 'options/clone.php' );
?>

<div class="panel">
    <div class="panel-heading">
        <div class="level-item icon-select" style="color: #ffffff; background-color: #128be0;">
            <i class="fas fa-hand-point-up"></i>
        </div>
        <div class="level-item">
            <span class="item-label-text">(<?php esc_attr_e( 'no label', 'side-menu' ); ?>)</span>
        </div>
        <div class="level-item element-type">
            Link
        </div>
        <div class="level-item toogle-element">
            <span class="dashicons dashicons-arrow-down is-hidden"></span>
            <span class="dashicons dashicons-arrow-up"></span>
        </div>
    </div>
    <div class="toogle-content">
        <div class="panel-block">
            <div class="field">
                <label class="label is-small">
					<?php esc_attr_e( 'Label Text', 'side-menu' ); ?>
                </label>
				<?php self::option( $menu_1_item_tooltip ); ?>
            </div>
        </div>
        <label class="panel-block panel-sub-item">
		    <?php self::option( $menu_1_sub_item ); ?><?php esc_attr_e( 'Sub-Item', 'side-menu' ); ?>
        </label>
        <label class="panel-block hold-item-open">
			<?php self::option( $menu_1_hold_open ); ?><?php esc_attr_e( 'Hold open', 'side-menu' ); ?>
        </label>
        <p class="panel-tabs">
            <a class="is-active" data-tab="1"><?php esc_attr_e( "Type", 'side-menu' ); ?></a>
            <a data-tab="2"><?php esc_attr_e( "Icon", 'side-menu' ); ?></a>
            <a data-tab="3"><?php esc_attr_e( "Style", 'side-menu' ); ?></a>
            <a data-tab="4"><?php esc_attr_e( "Attributes", 'side-menu' ); ?></a>
            <a data-tab="5"><?php esc_attr_e( "Extra Text", 'side-menu' ); ?></a>
        </p>
        <div data-tab-content="1" class="tabs-content">
            <div class="panel-block">
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'Item type', 'side-menu' ); ?><?php self::tooltip( $menu_1_item_type_help ); ?>

                    </label>
					<?php self::option( $menu_1_item_type ); ?>
                </div>
                <div class="field item-link">
                    <label class="label item-link-text">
						<?php esc_attr_e( 'Link', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_item_link ); ?>
                </div>
                <div class="field item-share">
                    <label class="label">
						<?php esc_attr_e( 'Social Networks', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_item_share ); ?>
                </div>
                <div class="field item-translate">
                    <label class="label">
						<?php esc_attr_e( 'Select Language', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_item_gtranslate ); ?>
                </div>
                <div class="field item-modal">
                    <label class="label">
						<?php esc_attr_e( 'Enter value', 'side-menu' ); ?>: <br/>
                    </label>
					<?php self::option( $menu_1_item_modal ); ?>
                    <p class="help"><?php esc_attr_e( '(e.g.: wow-modal-id-1)', 'side-menu' ); ?></p>
                </div>
            </div>
            <label class="panel-block item-link-blank">
				<?php self::option( $menu_1_new_tab ); ?><?php esc_attr_e( 'Open link in a new tab', 'side-menu' ); ?>
            </label>
        </div>
        <div data-tab-content="2" class="tabs-content is-hidden">
            <div class="panel-block icon-default">
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'Icon', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_item_icon ); ?>
                </div>
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'Animation', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_item_icon_anomate ); ?>
                </div>
            </div>
            <label class="panel-block">
				<?php self::option( $menu_1_item_custom ); ?><?php esc_attr_e( 'Custom icon', 'side-menu' ); ?>
            </label>
            <div class="panel-block icon-custom">
				<?php self::option( $menu_1_item_custom_link ); ?>
            </div>
            <div class="panel-block icon-custom">
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'Image Alt', 'side-menu' ); ?><?php self::tooltip( $menu_1_image_alt_help ); ?>
                    </label>
					<?php self::option( $menu_1_image_alt ); ?>
                </div>
            </div>

            <label class="panel-block icon-text">
		        <?php self::option( $menu_1_item_custom_text_check ); ?>
		        <?php esc_attr_e( 'Emoji, Glyphs, Letter', 'float-menu' ); ?>
		        <?php self::tooltip( $menu_1_item_custom_text_check_help ); ?>
            </label>
            <div class="panel-block icon-text-field is-hidden">
		        <?php self::option( $menu_1_item_custom_text ); ?>
            </div>

        </div>
        <div data-tab-content="3" class="tabs-content is-hidden">
            <div class="panel-block">
                <div class="columns">
                    <div class="field column">
                        <label class="label">
							<?php esc_attr_e( 'Icon Сolor', 'side-menu' ); ?>
                        </label>
						<?php self::option( $menu_1_iconcolor ); ?>
                    </div>
                    <div class="field column">
                        <label class="label">
							<?php esc_attr_e( 'Font Color', 'side-menu' ); ?>
                        </label>
						<?php self::option( $menu_1_color ); ?>
                    </div>
                </div>
            </div>
            <div class="panel-block">
                <div class="columns">
                    <div class="field column">
                        <label class="label">
							<?php esc_attr_e( 'Background', 'side-menu' ); ?>
                        </label>
						<?php self::option( $menu_1_bcolor ); ?>
                    </div>
                    <div class="field column">
                        <label class="label">
							<?php esc_attr_e( 'Background Hover', 'side-menu' ); ?>
                        </label>
						<?php self::option( $menu_1_hbcolor ); ?>
                    </div>
                </div>
            </div>
        </div>
        <div data-tab-content="4" class="tabs-content is-hidden">
            <div class="panel-block">
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'ID for element', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_button_id ); ?>
                </div>
            </div>
            <div class="panel-block">
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'Class for element', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_button_class ); ?>
                </div>
            </div>
            <div class="panel-block">
                <div class="field">
                    <label class="label">
						<?php esc_attr_e( 'Attribute: rel', 'side-menu' ); ?>
                    </label>
					<?php self::option( $menu_1_link_rel ); ?>
                </div>
            </div>

        </div>
        <div data-tab-content="5" class="tabs-content is-hidden">
            <div class="panel-block">
                <div class="field">
                    <label class="label">
				        <?php esc_attr_e( 'Extra text', 'side-menu' ); ?><?php self::tooltip( $item_text_help ); ?>
                    </label>
			        <?php self::option( $menu_1_item_text ); ?>
                </div>
            </div>
            <div class="panel-block">
                <div class="field">
                    <label class="label">
			            <?php esc_attr_e( 'Font Size', 'side-menu' ); ?>
                    </label>
		            <?php self::option( $menu_1_item_text_size ); ?>
                </div>

                <div class="field">
                    <label class="label">
				        <?php esc_attr_e( 'Width', 'side-menu' ); ?>
                    </label>
                    <div class="field has-addons">
				        <?php self::option( $menu_1_item_text_width ); ?>
                        <div class="control">
                            <span class="addon">px</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel-block actions">
            <a class="item-delete"><?php esc_attr_e( 'Remove', 'side-menu' ); ?></a>
        </div>
    </div>
</div>
