<?php
/**
 * Add new Element
 *
 * @package     Wow_Plugin
 * @subpackage  Admin/Add_Item
 * @author      Wow-Company <yoda@wow-company.com>
 * @copyright   2019 Wow-Company
 * @license     GNU Public License
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// include the database params for item
include_once( 'settings/database.php' );

// include the options param
include_once( 'settings/options/general.php' );

$url_form = admin_url() . 'admin.php?page=' . $this->plugin['slug'];
?>
    <form action="<?php
	echo esc_url( $url_form ); ?>" method="post" name="post" class="wow-plugin" id="wow-plugin">
        <div id="poststuff">
            <div id="post-body" class="metabox-holder columns-2">
                <div id="post-body-content" style="position: relative;">

                    <div id="titlediv">

                        <div id="titlewrap">
                            <label class="screen-reader-text" id="title-prompt-text" for="title">Enter title
                                here</label>
                            <input type="text" class="input" name="title" size="30" value="<?php
							echo esc_attr( $title ); ?>" id="title" placeholder="<?php
							esc_attr_e( 'Register an menu name', 'side-menu' ); ?>" autocomplete="off">
                        </div>

                    </div>
                </div>

                <!--      Sidebar with the setting-->
                <div id="postbox-container-1" class="postbox-container">

                    <div id="submitdiv" class="box">
                        <h2 class="has-border-bottom">
							<?php
							esc_html_e( 'Publish', 'side-menu' ); ?>
                        </h2>

                        <div class="inside">
                            <div class="columns is-multiline">
                                <div class="column is-12">
                                    <div class="field">
                                        <label class="checkbox label">
											<?php
											self::option( $status ); ?><?php
											esc_attr_e( "Deactivated", 'side-menu' ); ?><?php
											self::tooltip( $status_help ); ?>
                                        </label>
                                    </div>
                                    <div class="field">
                                        <label class="checkbox label">
											<?php
											self::option( $test_mode ); ?><?php
											esc_attr_e( "Test mode", 'side-menu' ); ?><?php
											self::tooltip( $test_mode_help ); ?>
                                        </label>
                                    </div>

                                </div>
                                <div class="column is-12">
                                    <div class="field">
										<?php
										self::option( $show ); ?>
                                    </div>
                                    <div class="field" id="taxonomy">
										<?php
										self::option( $taxonomy ); ?>
                                    </div>
                                    <div class="field" id="id-post">
										<?php
										self::option( $id_post ); ?>
                                    </div>

                                    <div class="control" id="shortcode">
                                        <input class="input" type="text" value="[<?php
										echo esc_attr( $this->plugin['shortcode'] ); ?> id='<?php
										echo absint( $tool_id ); ?>']" readonly>
                                    </div>

                                </div>
                            </div>

                            <div class="submitbox has-border-top" id="submitpost">
                                <div id="delete-action">
									<?php
									if ( ! empty( $id ) ) : ?><?php
										$delete_url = admin_url() . 'admin.php?page=' . $this->plugin['slug'] . '&info=delete&did=' . absint( $id ); ?>
                                        <a class="submitdelete deletion" href="<?php
										echo esc_url( $delete_url ); ?>"><?php
											esc_attr_e( 'Delete', 'side-menu' ); ?></a>
									<?php
									endif; ?>
                                </div>

                                <div id="publishing-action">
                                    <span class="saving"><?php
	                                    esc_html_e( 'Saving', 'side-menu' ); ?></span>
                                    <input name="submit" id="submit" class="button button-primary button-large"
                                           value="<?php
									       echo esc_attr( $btn ); ?>" type="submit">
                                </div>

                                <div class="clear"></div>


                            </div>
                        </div>
                    </div>
                </div>

                <!--      Block for main options pages-->

                <div id="postoptions">

                    <div id="postbox-container-2" class="postbox-container">

                        <div class="tabs is-boxed" id="tab">
                            <ul>
                                <li class="is-active" data-tab="1">
                                    <a>
                                        <span class="icon is-small"><i class="fa-solid fa-bars" aria-hidden="true"></i></span>
										<?php
										esc_html_e( 'Menu', 'side-menu' ); ?>
                                    </a>
                                </li>
                                <li data-tab="2">
                                    <a>
                                        <span class="icon is-small"><i class="fa-solid fa-gears" aria-hidden="true"></i></span>
										<?php
										esc_html_e( 'Settings', 'side-menu' ); ?>
                                    </a>
                                </li>
                                <li data-tab="3">
                                    <a>
                                        <span class="icon is-small"><i class="fa-regular fa-eye" aria-hidden="true"></i></span>
										<?php
										esc_html_e( 'Display', 'side-menu' ); ?>
                                    </a>
                                </li>
                                <li data-tab="4">
                                    <a>
                                        <span class="icon is-small"><i class="fa-brands fa-css3" aria-hidden="true"></i></span>
			                            <?php
			                            esc_html_e( 'Custom CSS', 'side-menu' ); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>

                        <div class="columns box has-tabs">

                            <div class="column">

                                <div id="tab-content" class="inside">
                                    <div class="tab-content is-active" data-content="1">
										<?php include_once( 'settings/menu.php' ); ?>
                                    </div>

                                    <div class="tab-content" data-content="2">
										<?php include_once( 'settings/main.php' ); ?>
                                    </div>
                                    <div class="tab-content" data-content="3">
										<?php include_once( 'settings/display.php' ); ?>
                                    </div>
                                    <div class="tab-content" data-content="4">
		                                <?php  include_once( 'settings/style.php' ); ?>
                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>
                </div>

            </div>
        </div>

        <!--  main param for adding in database-->
        <input type="hidden" name="tool_id" value="<?php
		echo absint( $tool_id ); ?>" id="tool_id"/>
        <input type="hidden" name="add" id="add_action" value="<?php
		echo absint( $add_action ); ?>"/>
        <input type="hidden" name="prefix" value="<?php
		echo esc_attr( $this->plugin['prefix'] ); ?>" id="prefix"/>
		<?php
		wp_nonce_field( $this->plugin['slug'] . '_action', $this->plugin['slug'] . '_nonce' ); ?>

    </form>

    <template id="clone">
		<?php
		include_once( 'settings/clone.php' ); ?>
    </template>

    <template id="clone-day">
        <div class="columns">
            <div class="column is-4">
                <div class="field">
                    <label class="label">
						<?php
						esc_html_e( 'Day of the week', 'side-menu' ); ?><span
                                class="wow-help dashicons dashicons-editor-help"
                                title="Select the day of the week when the menu will be displayed."></span>
                    </label>

                    <div class="control">
                        <div class="select is-fullwidth">
                            <select name="param[weekday_arr][]" class="" id="weekday">
                                <option value="none" selected="selected">Everyday</option>
                                <option value="1">Monday</option>
                                <option value="2">Tuesday</option>
                                <option value="3">Wednesday</option>
                                <option value="4">Thursday</option>
                                <option value="5">Friday</option>
                                <option value="6">Saturday</option>
                                <option value="7">Sunday</option>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <div class="column is-4">
                <div class="field">
                    <label class="label">
                        Time from<span class="wow-help dashicons dashicons-editor-help"
                                       title="Specify what from time of the day to show the menu"></span> </label>
                    <div class="control is-expanded">
                        <input type="time" name="param[time_start_arr][]" value="00:00" id="time_start" class="input ">
                    </div>
                </div>
            </div>
            <div class="column is-4">
                <div class="field">
                    <label class="label">
                        Time to<span class="wow-help dashicons dashicons-editor-help"
                                     title="Specify what to time of the day to show the menu"></span> </label>
                    <div class="control is-expanded">
                        <input type="time" name="param[time_end_arr][]" value="23:59" id="time_end" class="input ">
                    </div>
                </div>
            </div>
        </div>

    </template>

<?php
