/**
 * age popup features
 * @var object ct_ultimate_gdpr_age - from wp_localize_script
 * @var object ct_ultimate_gdpr_age_shortcode_popup - from wp_localize_script
 *
 * */
jQuery(document).ready(function ($) {

    function hidePopup() {

        jQuery('#ct-ultimate-gdpr-age-popup').hide();
        jQuery('.ct-ultimate-gdpr-age-fullPanel-overlay').hide();
        jQuery('#ct-ultimate-gdpr-age-open').show();
    }

    function showPopup() {
        jQuery('#ct-ultimate-gdpr-age-popup').show();
    }

    function getCookie(name) {
        var ctCookie = document.cookie;
        if (ctCookie) {
            var match = ctCookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
            if (match) return match[2];
        } else {
            return '';
        }

    }

    function isConsentValid() {

        // on some setups php is unable to grab cookie in backend, then check in js below
        if (ct_ultimate_gdpr_age.consent) {
            return true;
        }

        var cookieValue = getCookie('ct-ultimate-gdpr-age');

        //fix for old version of the plugin
        if(cookieValue){
            var myCookieIsFromOldVersion = (cookieValue.indexOf("consent") !== -1);
            if(myCookieIsFromOldVersion){
                document.cookie = "ct-ultimate-gdpr-age" + '=; expires=Thu, 01 Jan 1970 00:00:01 GMT;';
                return  false;
            }
        }

        var cookieObject = cookieValue ? JSON.parse(atob(decodeURIComponent(cookieValue))) : {};

        //checking for latest/legacy expire_time js implementation
        if (cookieObject.consent_expire_time) {
            return cookieObject.consent_expire_time > +new Date / 1000;
        } else if (cookieObject.expire_time) {
            return cookieObject.expire_time > +new Date / 1000;
        } else {
            return false;
        }

    }

    // hide popup and show small gear icon if user already given consent
    if (isConsentValid()) {
        hidePopup();
    } else {
        showPopup();
    }

    function setJsCookie(consent_level) {

        try {

            var consent_expire_time = ct_ultimate_gdpr_age.consent_expire_time;
            var consent_time = ct_ultimate_gdpr_age.consent_time;
            var content = {
                'consent_level': consent_level,
                'consent_expire_time': consent_expire_time,
                'consent_time': consent_time,
                'consent_declined': false
            };

            content = btoa(JSON.stringify(content));
            var js_expire_time = new Date(1000 * consent_expire_time).toUTCString();
            document.cookie = "ct-ultimate-gdpr-age=" + content + "; expires=" + js_expire_time + "; path=/";

        } catch (e) {

        }

    }

    function onAccept() {

        var level = ct_ultimate_gdpr_age.consent_accept_level;
        var $this = $(this);
        setJsCookie(level);

        jQuery.post(ct_ultimate_gdpr_age.ajaxurl, {
                "action": "ct_ultimate_gdpr_age_consent_give",
                "level": level
            }
        ).fail(function () {


            jQuery.post(ct_ultimate_gdpr_age.ajaxurl, {
                "skip_cookies": true,
                "action": "ct_ultimate_gdpr_age_consent_give",
                "level": level
            });

        });

            hidePopup()

        $('body').removeClass("ct-ultimate-gdpr-age-bottomPanel-padding");
        $('body').removeClass("ct-ultimate-gdpr-age-topPanel-padding");


    }


    $('#ct-ultimate-gdpr-age-accept').bind('click', onAccept);

    //SVG
    jQuery('img.ct-svg').each(function () {
        var $img = jQuery(this);
        var imgID = $img.attr('id');
        var imgClass = $img.attr('class');
        var imgURL = $img.attr('src');

        jQuery.get(imgURL, function (data) {
            // Get the SVG tag, ignore the rest
            var $svg = jQuery(data).find('svg');

            // Add replaced image's ID to the new SVG
            if (typeof imgID !== 'undefined') {
                $svg = $svg.attr('id', imgID);
            }
            // Add replaced image's classes to the new SVG
            if (typeof imgClass !== 'undefined') {
                $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }

            // Remove any invalid XML tags as per http://validator.w3.org
            $svg = $svg.removeAttr('xmlns:a');

            // Check if the viewport is set, else we gonna set it if we can.
            if (!$svg.attr('viewBox') && $svg.attr('height') && $svg.attr('width')) {
                $svg.attr('viewBox', '0 0 ' + $svg.attr('height') + ' ' + $svg.attr('width'))
            }

            // Replace image with new SVG
            $img.replaceWith($svg);

        }, 'xml');
    });


    $(window).on('load', function () {

        if( getCookie('ct-ultimate-gdpr-age-popup') == 1 ){
            jQuery('#ct-ultimate-gdpr-age-popup').hide();
            jQuery('.ct-ultimate-gdpr-age-fullPanel-overlay').hide();
        }
    });


    if ($("#ct-ultimate-gdpr-age-popup").hasClass("ct-ultimate-gdpr-age-topPanel")) {
        if (!ct_ultimate_gdpr_age.consent) {
            $('body').addClass("ct-ultimate-gdpr-age-topPanel-padding");
        }
    }

    if ($("#ct-ultimate-gdpr-age-popup").hasClass("ct-ultimate-gdpr-age-bottomPanel")) {
        if (!ct_ultimate_gdpr_age.consent) {
            $('body').addClass("ct-ultimate-gdpr-age-bottomPanel-padding");
        }
    }

    if ($("#ct-ultimate-gdpr-age-popup").hasClass("ct-ultimate-gdpr-age-topPanel ct-ultimate-gdpr-age-popup-modern")) {
        $('body').addClass("popup-modern-style");
    }

    if ($("#ct-ultimate-gdpr-age-popup").hasClass("ct-ultimate-gdpr-age-bottomPanel ct-ultimate-gdpr-age-popup-modern")) {
        $('body').addClass("popup-modern-style");
    }

    $(window).on('load resize', function() {
        var agePopupHeight = $('#ct-ultimate-gdpr-age-popup').outerHeight();

        $('.ct-ultimate-gdpr-age-bottomPanel-padding').css('padding-bottom', agePopupHeight);
    });

});