<?php
/*
Name: SYNC client templates and cliparts
Description: SYNC client templates and cliparts
Version: 1.0
Compatible: 1.9.5
*/

class lumise_addon_sync_client_templates_cliparts extends lumise_addons {

	protected $_apiServer = 'https://sync.lumise.com/home/';
	protected $_apiServerFile = 'https://sync.lumise.com/assets/';
	
	function __construct() {
		global $lumise;

		// Insert js addon
		$lumise->add_action('editor-footer', array(&$this, 'editor_footer'));

		// ajax
		$lumise->add_action('addon-ajax', array(&$this, 'ajax_action'));

		// REST API for addon SYNC
		if ($lumise->connector->platform == 'woocommerce') {
			add_action('rest_api_init', function () {
			  register_rest_route( 'lumise_addon/v1', 'sync_check/(?P<sync_id>\d+)',array(
			                'methods'  => 'POST',
			                'callback' => array(&$this, 'rest_api_check')
			      ));
			});
		}

		if ($lumise->connector->platform == 'php') {
			$lumise->add_action('api_request', array(&$this, 'rest_api_check'));
		}
	}

	public function rest_api_check(){
		global $lumise;

		if($lumise->connector->platform == 'php'){
			if(!isset($_REQUEST['api_action']) || $_REQUEST['api_action'] != 'addon_sync'){
				return;
			}
		}
		
		// check parameter
		if( !isset($_POST['name']) || !isset($_POST['thumbnail']) || !isset($_POST['type']) || !isset($_POST['url']) || !isset($_POST['file_name']) || !isset($_POST['thumbnail_name']) ){
			echo json_encode(array('status' => 0, 'message' => 'missing data'));
			die();
		}

		// check exist
		if($_POST['type'] == 'cliparts'){
			$_table = $lumise->lib->sql_esc($lumise->db->prefix."cliparts");
			$insert_thumbnail = 'thumbnail_url';
		}
		if($_POST['type'] == 'templates'){
			$_table = $lumise->lib->sql_esc($lumise->db->prefix."templates");
			$insert_thumbnail = 'screenshot';
		}

		$file_name = preg_replace('/[^a-zA-Z0-9-.:_]+/mi', '', $_POST['file_name']);
		$thumbnail_name = preg_replace('/[^a-zA-Z0-9-.:_]+/mi', '', $_POST['thumbnail_name']);
		$excute = $lumise->db->rawQuery('SELECT id FROM '.$_table.' WHERE upload LIKE "%'.$lumise->lib->sql_esc($file_name).'%" LIMIT 1');

		// exist break out
		if(count($excute) > 0){
			echo json_encode(array('status' => 1, 'message' => 'exist'));
			die();
		}

		if(DIRECTORY_SEPARATOR == "\\"){
			// window type
			define('DS_ADDON', "/" ); 
		} else {
			// linux type
			define('DS_ADDON', DIRECTORY_SEPARATOR );
		}

		// create file
		$time = time();
		$name = preg_replace('/[^a-zA-Z0-9-.:_]+/mi', '', $_POST['name']);

		$file_name_insert = date('Y', $time).DS_ADDON.date('m', $time).DS_ADDON.$file_name;
		$thumbnail_name_insert = date('Y', $time).DS_ADDON.date('m', $time).DS_ADDON.$thumbnail_name;

		// check folder exist
		if(is_dir($lumise->cfg->upload_path.$_POST['type'].DS_ADDON.date('Y', $time).DS_ADDON.date('m', $time)) == FALSE){
			mkdir($lumise->cfg->upload_path.$_POST['type'].DS_ADDON.date('Y', $time).DS_ADDON.date('m', $time), 0777, true);
		}

		$file_url = file_put_contents( $lumise->cfg->upload_path.$_POST['type'].DS_ADDON.$file_name_insert, file_get_contents($this->_apiServerFile.$_POST['url']));
		$file_thumbnail = file_put_contents( $lumise->cfg->upload_path.$_POST['type'].DS_ADDON.$thumbnail_name_insert, file_get_contents($this->_apiServerFile.$_POST['thumbnail']));

		// insert
		$excute = $lumise->db->rawQuery('INSERT INTO '.$_table.'(name, '.$insert_thumbnail.', upload, created, updated, tags) VALUES ("'.$name.'", "'.$lumise->cfg->upload_url.$_POST['type'].DS_ADDON.$thumbnail_name_insert.'", "'.$_POST['type'].DS_ADDON.$file_name_insert.'", "'.date('yy-m-d H:i:s').'", "'.date('yy-m-d H:i:s').'", "") ');
		
		echo json_encode(array('status' => 2, 'message' => 'success'));
		die();

	}

	public function settings() {
		global $lumise;
		
		return array(
			array(
				'type' => 'input',
				'name' => 'lumise_customer_subscribe',
				'label' => $lumise->lang('Categories Follow'),
				'desc' => '<font color="red">'.$lumise->lang('Categories ').'</font> <a href="#" target=_blank>'.$lumise->lang('[Read more]').'</a>'
			),
			array(
				'type' => 'dropbox',
				'name' => 'lumise_customer_sync',
				'label' => $lumise->lang('Sync type'),
				'desc' => '<font color="red">'.$lumise->lang('Tutorial ').'</font> <a href="#" target=_blank>'.$lumise->lang('[Read more]').'</a>',
				'options' => array(
					'all' => 'All Templates & Cliparts',
					'templates' => 'Only templates',
					'cliparts' => 'Only Cliparts'
				)
			),
		);
	}

	public function editor_footer() {

		if($this->is_backend()){
			echo '<script type="text/javascript">var sync_vari = {
				loading_image : "'.$this->get_url('assets/images/loading.gif').'"
			};</script>';
			echo '<link media="all" rel="stylesheet" href="'.$this->get_url('assets/css/select2.min.css?ver=1').'" />';
			echo '<script type="text/javascript" src="'.$this->get_url('assets/js/select2.min.js?ver=1').'" defer></script>';
			echo '<script type="text/javascript" src="'.$this->get_url('assets/js/backend.js?ver=1').'" defer></script>';
		}
	}

	public function ajax_action(){
		global $lumise;
		
		// status = 1 subed
		// status = 2 nearly expired
		// status = 3 expired
		// status = 4 unsub
		
		if (isset($_POST['component']) && $_POST['component'] == 'checksub') {
			$platform = $lumise->connector->platform;
			$getRequest = $this->getRequest($this->_apiServer.'check?ref='.$_SERVER['HTTP_REFERER'].'&platform='.$platform);
			echo $getRequest;
			die();
		}

		if (isset($_POST['component']) && $_POST['component'] == 'verify_sync') {
			$getRequest = $this->getRequest($this->_apiServer.'verify_sync?ref='.$_SERVER['HTTP_REFERER']);
			echo $getRequest;
			die();
		}

		if (isset($_POST['component']) && $_POST['component'] == 'pushsub' && isset($_POST['subcribe_id']) ) {
			$getRequest = $this->getRequest($this->_apiServer.'push?subcribe_id='.intval($_POST['subcribe_id']).'&ref='.$_SERVER['HTTP_REFERER']);
			echo $getRequest;
			die();
		}

		if (isset($_POST['component']) && $_POST['component'] == 'sync') {
			$type = $_POST['type'];
			$getRequest = json_decode($this->getRequest($this->_apiServer.'sync?type='.$type.'&ref='.$_SERVER['HTTP_REFERER']));
			if($getRequest->status == 1 || $getRequest->status == 2){
				// do something with subed
			}
			echo json_encode($getRequest);
			die();
		}

		if (isset($_POST['component']) && $_POST['component'] == 'sync_push') {

			// check parameter
			if( !isset($_POST['name']) || !isset($_POST['thumbnail']) || !isset($_POST['type']) || !isset($_POST['url']) || !isset($_POST['file_name']) || !isset($_POST['thumbnail_name']) ){
				echo json_encode(array('status' => 0, 'message' => 'missing data'));
				die();
			}

			// check exist
			if($_POST['type'] == 'cliparts'){
				$_table = $lumise->lib->sql_esc($lumise->db->prefix."cliparts");
				$insert_thumbnail = 'thumbnail_url';
			}
			if($_POST['type'] == 'templates'){
				$_table = $lumise->lib->sql_esc($lumise->db->prefix."templates");
				$insert_thumbnail = 'screenshot';
			}

			$file_name = preg_replace('/[^a-zA-Z0-9-.:_]+/mi', '', $_POST['file_name']);
			$thumbnail_name = preg_replace('/[^a-zA-Z0-9-.:_]+/mi', '', $_POST['thumbnail_name']);
			$excute = $lumise->db->rawQuery('SELECT id FROM '.$_table.' WHERE upload LIKE "%'.$lumise->lib->sql_esc($file_name).'%" LIMIT 1');

			// exist break out
			if(count($excute) > 0){
				echo json_encode(array('status' => 1, 'message' => 'success'));
				die();
			}

			if(DIRECTORY_SEPARATOR == "\\"){
				// window type
				define('DS_ADDON', "/" ); 
			} else {
				// linux type
				define('DS_ADDON', DIRECTORY_SEPARATOR );
			}

			// create file
			$time = time();
			$name = preg_replace('/[^a-zA-Z0-9-.:_]+/mi', '', $_POST['name']);

			$file_name_insert = date('Y', $time).DS_ADDON.date('m', $time).DS_ADDON.$file_name;
			$thumbnail_name_insert = date('Y', $time).DS_ADDON.date('m', $time).DS_ADDON.$thumbnail_name;

			$file_url = file_put_contents( $lumise->cfg->upload_path.$_POST['type'].DS_ADDON.$file_name_insert, file_get_contents($this->_apiServerFile.$_POST['url']));
			$file_thumbnail = file_put_contents( $lumise->cfg->upload_path.$_POST['type'].DS_ADDON.$thumbnail_name_insert, file_get_contents($this->_apiServerFile.$_POST['thumbnail']));

			// insert
			$excute = $lumise->db->rawQuery('INSERT INTO '.$_table.'(name, '.$insert_thumbnail.', upload, created, updated, tags) VALUES ("'.$name.'", "'.$lumise->cfg->upload_url.$_POST['type'].DS_ADDON.$thumbnail_name_insert.'", "'.$file_name_insert.'", "'.date('yy-m-d H:i:s').'", "'.date('yy-m-d H:i:s').'", "") ');
			echo json_encode(array('status' => 1, 'message' => 'success'));
			die();
		}
	}

	public function getRequest($urlRequest = '') {
		global $lumise;

		$ch = curl_init($urlRequest);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array("Referer: ".$_SERVER['HTTP_HOST']));
		$result = curl_exec($ch);
		if ($result == FALSE || $result == NULL || curl_getinfo($ch, CURLINFO_HTTP_CODE) != 200) {
			echo json_encode(array('status' => 0, 'message' => $lumise->lang('connect to server error, plz try again after some minutes!')));
			die();
        }
		curl_close($ch);
		return $result;
	}

	/*
		Actions on active or deactive this addon
	*/
	static function active() {
		global $lumise;

		$lumise->set_option('lumise_customer_subscribe' , '');
		$lumise->set_option('lumise_customer_sync' , '');
	}
	
	static function deactive() {
		global $lumise;
		
	}
	
}