(function($) { 
	var width_document = $( document ).width();

	$.urlParam = function(name){
		var results = new RegExp('[\?&]' + name + '=([^&#]*)').exec(window.location.href);
		if(results == undefined){
			return '';
		}
		return results[1] || 0;
	}

	if($.urlParam('name') == 'sync_client_templates_cliparts'){
		var loading_svg = '<?xml version="1.0" encoding="utf-8"?><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" style="margin: auto; background: none; display: block; shape-rendering: auto;" width="30px" height="30px" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid"><g transform="rotate(0 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.9166666666666666s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(30 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.8333333333333334s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(60 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.75s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(90 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.6666666666666666s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(120 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.5833333333333334s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(150 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.5s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(180 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.4166666666666667s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(210 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.3333333333333333s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(240 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.25s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(270 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.16666666666666666s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(300 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="-0.08333333333333333s" repeatCount="indefinite"></animate> </rect></g><g transform="rotate(330 50 50)"> <rect x="47" y="24" rx="3" ry="6" width="6" height="12" fill="#fdea42"> <animate attributeName="opacity" values="1;0" keyTimes="0;1" dur="1s" begin="0s" repeatCount="indefinite"></animate> </rect></g></svg>';
		var sync_client_btn = '<button data-request="false" style="float: right; min-height: 38px; min-width: 183px; text-transform: uppercase; font-weight: bold;" class="lumise-button lumise-button-primary sync_client">SYNC Client</button>';

		$('[name="lumise_customer_subscribe"]').hide();

		$('[name="lumise_customer_subscribe"]').parent().prepend('<select name="sl_subcribe"><option value="-1">Select a categories</option></select>');

		$('form#lumise-clipart-form .lumise_form_group.lumise_field_input, form#lumise-clipart-form .lumise_form_group.lumise_field_dropbox').hide();

		$('form#lumise-clipart-form .lumise_form_group.lumise_form_submit .lumise-button.lumise-button-primary').hide();
		var verify = '<input type="button" data-func="verify_sync" class="lumise-button lumise-button-primary" value="Verify">';

		$('form#lumise-clipart-form').prepend('<div class="lumise_form_group text-center alert_lumise">conntecting to server waiting</br><img src="'+sync_vari.loading_image+'" alt="" /></div>');
		
		$.ajax({
			url: LumiseDesign.ajax,
			method: 'POST',
			dataType: "json",
			data: {
				nonce: 'LUMISE_ADMIN:'+LumiseDesign.nonce,
				ajax: 'backend',
				action: 'addon',
				component: 'checksub',
			},
			success: function(result){
				if(result.status == 0){
					$('.alert_lumise').html('<p style="text-align: center;">'+result.message+'</p>');
					// alert(result.message);
					return;
				}

				var sublist = [];
				$.each(result.list, function(index, detail){
					sublist.push({ id: detail.subcribe_id, text: detail.subcribe_name });
				});


				if(result.status == 1){
					$('.alert_lumise').html('');

					$('form#lumise-clipart-form .lumise_form_group.lumise_form_submit').append(verify);

					// $('form#lumise-clipart-form .lumise_form_group.lumise_field_input, form#lumise-clipart-form .lumise_form_group.lumise_field_dropbox').show();

					// if(width_document >= 768){
					// 	$('#lumise-addon-page .lumise_header').append(sync_client_btn);
					// }
					// if(width_document < 768){
					// 	$('.lumise_form_content').append(sync_client_btn);
					// }

				}
				if(result.status == 2 || result.status == 3 ||  result.status == 4){
					$('.alert_lumise').html('<p style="color:red;">(*) '+result.message+'</p>');
					$('form#lumise-clipart-form .lumise_form_group.lumise_field_input').show();
				}

				$('select[name="sl_subcribe"]').select2({
					placeholder: 'Select a subcribe',
					multiple: false,
					data: sublist
				});

				if(result.subcribe_id != ''){
					$('select[name="sl_subcribe"]').val(result.subcribe_id);
					$('select[name="sl_subcribe"]').trigger('change');
				}
			}
		});
	}

	$(document).on('click', 'input[data-func="verify_sync"]', function(){

		$(this).val('Connect to server, please waiting....');

		$.ajax({
			url: LumiseDesign.ajax,
			method: 'POST',
			dataType: "json",
			data: {
				nonce: 'LUMISE_ADMIN:'+LumiseDesign.nonce,
				ajax: 'backend',
				action: 'addon',
				component: 'verify_sync',
			},
			success: function(result){
				if(result.status == 0){
					$('.alert_lumise').html('<p style="text-align: center;">'+result.message+'</p>');
					// alert(result.message);
					return;
				}

				if(result.status == 1){
					$('input[data-func="verify_sync"]').val('success');
				}
			}
		});
	});

	$('input[type="submit"].lumise-button-primary').click(function(e){
		if($('[name="lumise_customer_subscribe"]').length){
			e.preventDefault();
			var subcribe_id = $('select[name="sl_subcribe"]').val();

			$(this).val('Connect to server, please waiting....');

			$.ajax({
				url: LumiseDesign.ajax,
				method: 'POST',
				dataType: "json",
				data: {
					nonce: 'LUMISE_ADMIN:'+LumiseDesign.nonce,
					ajax: 'backend',
					action: 'addon',
					component: 'pushsub',
					subcribe_id: subcribe_id
				},
				success: function(result){
					if(result.status == 0){
						alert(result.message);
						return;
					}
					if(result.status == 1){
						$('input[type="submit"].lumise-button-primary').val('update success');
						setTimeout(function(){ $('input[type="submit"].lumise-button-primary').val('Save Addon Settings'); }, 1500);
						return;
					}
				}
			});
		}
	});

	$(document).on('click', '.sync_client', function(){
		$(this).html(loading_svg);
		if($(this).attr('data-request') == 'true' || $(this).attr('data-request') == true){
			return;
		}
		$(this).attr('data-request', true);

		$.ajax({
			url: LumiseDesign.ajax,
			method: 'POST',
			dataType: "json",
			data: {
				nonce: 'LUMISE_ADMIN:'+LumiseDesign.nonce,
				ajax: 'backend',
				action: 'addon',
				component: 'sync',
				type: $('select[name="lumise_customer_sync"]').val()
			},
			success: function(result){
				if(result.status == 0){
					$('.sync_client').html(sync_client_btn);
					alert(result.message);
					return;
				}
				if(result.status == 1){
					$('.alert_lumise').html('<p style="color:red;">(*) sync processing....0/'+result.list.length+' file</p>');
					sync_data(result.list, 0);
				}
			}
		});
	});

	function sync_data(list, index){
		console.log(list.length);
		console.log((index));
		$.ajax({
			url: LumiseDesign.ajax,
			method: 'POST',
			dataType: "json",
			data: {
				nonce: 'LUMISE_ADMIN:'+LumiseDesign.nonce,
				ajax: 'backend',
				action: 'addon',
				component: 'sync_push',
				name: list[index].name,
				thumbnail: list[index].thumbnail,
				type: list[index].type,
				url: list[index].url,
				file_name: list[index].file_name,
				thumbnail_name: list[index].thumbnail_name
			},
			success: function(result){
				index+=1;
				if(result.status == 0){
					$('.sync_client').html(sync_client_btn);
					alert(result.message);
					return;
				}
				if(result.status == 1){;
					if(list.length <= index){
						$('.alert_lumise').html('<p style="color:green;">(*) sync success</p>');
						$('.sync_client').html(sync_client_btn);
						return;
					}
					$('.alert_lumise').html('<p style="color:red;">(*) sync processing....'+index+'/'+list.length+' file</p>');
					sync_data(list, index);
				}
			}
		});
	}

})(jQuery);