<?php
/*
Name: Price discount
Description: Create discount ruler for product
Version: 1.0
Compatible: 1.7.5
*/

class lumise_addon_price_discount extends lumise_addons {
	
	function __construct() {

		global $lumise;

		// Access core js via your JS function name 
		$this->access_corejs('lumise_addon_price_discount');

		// Add new left menu in backend	
		$lumise->add_filter('admin_menus', array(&$this, 'admin_menus'));

		// include backend page
		$lumise->add_filter('admin_page', array(&$this, 'admin_page'));

		// Insert js addon
		$lumise->add_action('editor-footer', array(&$this, 'editor_footer'));

		// single product show price tabe
		add_action('woocommerce_after_add_to_cart_form', array(&$this, 'show_table'), 9);

		// ajax
		add_action('wp_ajax_nopriv_lumise_show_table_price', array(&$this, 'lumise_show_table_price'));
		add_action('wp_ajax_lumise_show_table_price', array(&$this, 'lumise_show_table_price'));

		$lumise->add_action('addon-ajax', array(&$this, 'lumise_change_single_product_ed'));

		// add js
		add_action('wp_footer', array($this, 'footer_script') );

		// mini cart
		add_filter('woocommerce_widget_cart_item_quantity', array(&$this, 'lumise_mini_cart_price'), 99, 3);

		// detail cart
		add_filter('woocommerce_cart_item_price', array(&$this, 'lumise_cart_price'), 99, 3);

		// // subtotal inline
		// add_action( 'woocommerce_cart_item_subtotal', 'lumise_cart_item_subtotal', 99, 3 );

		// appy cart
		add_action( 'woocommerce_before_calculate_totals', array(&$this, 'lumise_calculate_totals'), 99, 1);

		// Add role for manage component 
		if ($lumise->connector->platform == 'woocommerce') {
			$role = get_role('administrator');
			$role->add_cap('lumise_edit_price_discounts');
			$role->add_cap('lumise_read_price_discounts');
			$role->add_cap('lumise_edit_add_price_discounts');
		}
	}

	public function footer_script(){
		global $product;

		// add js
		if(!is_admin() && is_product()){
			wp_enqueue_script( 'lumise_addon_price_discount_variable', $this->get_url('assets/js/price_discount_variable.js?ver=1') );
			wp_localize_script('lumise_addon_price_discount_variable', 'my_ajax_object', array( 'ajax_url' => admin_url( 'admin-ajax.php' ),  'product_id' => $product->get_id(), 'is_simple_product' => $product->is_type('simple'), 'is_variable_product' => $product->is_type('variable') ) );
		}
	}

	public function admin_menus($args) {

		global $lumise;
		
		$position = 2;
		
		$new_menu = array(
			"price_discount" => array(
				'title' => $lumise->lang('Price discount'),
				'icon'  => '<i class="fa fa-money"></i>',
				'child' => array(
					'price_discount' => array(
						'type'   => '',
						'title'  => $lumise->lang('Price discount rule'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=price_discount',
						'hidden' => false,
					),
					'add_price_discount' => array(
						'type'   => '',
						'title'  => $lumise->lang('Add New Price discount rule'),
						'link'   => $lumise->cfg->admin_url.'lumise-page=add_price_discount',
						'hidden' => false,
					),
				),
			)
		);
		
		return array_slice($args, 0, $position, true) + $new_menu + array_slice($args, $position, count($args) - 1, true);
	}

	public function admin_page($path, $page) {

		if ($page == 'price_discount'){
			return dirname(__FILE__).DS.'price_discount.php';
		}
		else if ($page == 'add_price_discount'){
			return dirname(__FILE__).DS.'add_price_discount.php';
		}
		else {
			return $path;
		}
	}

	public function lumise_change_single_product_ed($comp){
		global $lumise;

		if(
			isset($_POST['product_id']) 
			&& isset($_POST['ajax']) 
			&& $_POST['ajax'] == 'frontend' 
			&& isset($_POST['action']) 
			&& $_POST['action'] == 'addon'
			 && isset($_POST['component']) 
			 && $_POST['component'] == 'lumise_change_single_product_ed'
			){
			$_SESSION['productDiscountCalc'] = '[]';
			$_SESSION['productPrice'] = 0;
			$quantity = 1;

			$this->productDiscountCalc(array('product_id' => intval($_POST['product_id']), 'quantity' => $quantity));

			$result = array(
				'quantity' => $quantity,
				'price' => doubleval($_SESSION['productPrice']),
				'is_variable' => 0,
				'productDiscountCalc' => $_SESSION['productDiscountCalc']
			);
			echo json_encode(array('status' => 1, 'message' => $result));
			die();
		}
	}

	public function editor_footer() {
		
		if(!$this->is_backend()) {

			$product_id = 0;
			$price = 0;
			$quantity = 1;
			$is_variable = 0;
			$productDiscountCalc = 0;

			$_SESSION['productDiscountCalc'] = '[]';
			$_SESSION['productPrice'] = 0;

			if(isset($_REQUEST['quantity'])){
				$quantity = intval($_REQUEST['quantity']);
			}

			if(isset($_REQUEST['product_cms']) && isset($_REQUEST['product_base']) && strpos($_REQUEST['product_base'], "variable") !== FALSE){
				$product_id = intval(explode(":",$_REQUEST['product_base'])[1]);
				// $price = $this->productDiscountCalc(array('product_id' => $product_id, 'quantity' => $quantity));
				$price = $this->productDiscountCalc(array('product_id' => $product_id, 'quantity' => $quantity));
				$is_variable = 1;
				if($price == FALSE){
					$price = 0;
				}
				// $productDiscountCalc = $_SESSION['productDiscountCalc'];
				// $price = doubleval($_SESSION['productPrice']);
			}

			if(isset($_REQUEST['product_cms']) && isset($_REQUEST['product_base']) && strpos($_REQUEST['product_base'], "variable") === FALSE){
				$this->productDiscountCalc(array('product_id' => intval($_REQUEST['product_cms']), 'quantity' => $quantity));
				// $productDiscountCalc = $_SESSION['productDiscountCalc'];
				$price = doubleval($_SESSION['productPrice']);
				$is_variable = 0;
			}
			echo '<script type="text/javascript">var lumise_price_discount = {
				quantity : '.$quantity.',
				price: '.$price.',
				is_variable: '.$is_variable.',
				productDiscountCalc: '."'".$_SESSION['productDiscountCalc']."'".'
			};</script>';
			echo '<script type="text/javascript" src="'.$this->get_url('assets/js/price_discount.js?ver=1').'"></script>';
		}

		if($this->is_backend()){
			echo '<link media="all" rel="stylesheet" href="'.$this->get_url('assets/css/select2.min.css?ver=1').'" />';
			echo '<script type="text/javascript" src="'.$this->get_url('assets/js/select2.min.js?ver=1').'"></script>';
			echo '<script type="text/javascript" src="'.$this->get_url('assets/js/price_discount_backend.js?ver=1').'"></script>';
		}
	}

	public function productDiscountCalc($cart_item){
		global $lumise;

		$product_tags = '';
		$product_tag_list = array();
		$product_cates = '';
		$product_cate_list = array();
		$product_query = '';
		$container = '';

		$product_id = intval($cart_item['product_id']);

		$variable = wc_get_product($product_id);
		if($variable->get_parent_id() != 0){
			$product_id = intval($variable->get_parent_id());
		}

		// get cate
		$terms = get_the_terms( $product_id, 'product_cat' );

		if($terms != FALSE && count($terms) > 0){
			$product_cates .= ' ( ';
			foreach ($terms as $index => $detailTerm) {
				$product_cates .= '(FIND_IN_SET("'.intval($detailTerm->term_id).'", cate_product) != 0 AND FIND_IN_SET("'.intval($detailTerm->term_id).'", cate_product) IS NOT NULL ) OR ';
			}
			$product_cates = substr($product_cates, 0, -4);
			$product_cates .= ' ) OR ';
		}

		// get product tags
		$terms = wp_get_post_terms( $product_id, 'product_tag' );
		if($terms != FALSE && count($terms) > 0){
			$product_tags .= ' ( ';
			foreach ($terms as $index => $detailTerm) {
				$product_tags .= '(FIND_IN_SET("'.intval($detailTerm->term_id).'", tags_product) != 0 AND FIND_IN_SET("'.intval($detailTerm->term_id).'", tags_product) IS NOT NULL ) OR ';
			}
			$product_tags = substr($product_tags, 0, -4);
			$product_tags .= ' ) OR ';
		}
		
		// get product list
		$product_query = '(FIND_IN_SET("'.$product_id.'", product_list) != 0 AND FIND_IN_SET("'.$product_id.'", product_list) IS NOT NULL ) OR ';

		// check query 
		if($product_tags != '' || $product_cates != '' || $product_query != ''){
			$container = substr($product_query.$product_tags.$product_cates, 0, -4);
		}
		
		$query = "SELECT * FROM {$lumise->db->prefix}price_discount WHERE active = 1 AND (".$container.")";
		$datas = $lumise->db->rawQuery($query);
		if(count($datas) == 0){
			return false;
		}
		return $this->calcPriceTable($datas[0], $cart_item);
	}

	public function calcPriceTable($calcPrice, $cart_item){
		$_SESSION['productDiscountCalc'] = stripslashes($calcPrice['discount_rule']);
		$decodePriceDiscountRule = json_decode(stripslashes($calcPrice['discount_rule']));
		// $product = wc_get_product($cart_item['product_id']);
		// $_SESSION['productPrice'] = $price = $product->get_price();

		$product_id = intval($cart_item['product_id']);
		$product = wc_get_product($product_id);
		$_SESSION['productPrice'] = $price = doubleval($product->get_price());

		foreach ($decodePriceDiscountRule as $index => $detailDiscountRule) {
			// percentage calc detail cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $detailDiscountRule->discount_type == 'percentage'){
				// $total_price = (doubleval($price)*intval($cart_item['quantity']))*doubleval($detailDiscountRule->discount_value)/100/intval($cart_item['quantity']);
				$total_price = ((100-floatval($detailDiscountRule->discount_value))/100)*doubleval($price);
				return doubleval($total_price);
			}
			// fixed calc detail cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $detailDiscountRule->discount_type == 'fixed'){
				return doubleval($detailDiscountRule->discount_value);
			}
			// fixed minus calc detail cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $detailDiscountRule->discount_type == 'minus_fixed'){
				return doubleval(doubleval($price) - doubleval($detailDiscountRule->discount_value));
			}
		}
		return false;
	}

	public function lumise_show_table_price(){
		if(!isset($_REQUEST['product_id'])){
			echo json_encode(array('status' => 0, 'message' => ''));
			die();
		}

		global $lumise;

		$product = wc_get_product(intval($_REQUEST['product_id']));
		$product_tags = '';
		$product_tag_list = array();
		$product_cates = '';
		$product_cate_list = array();
		$product_query = '';
		$container = '';

		$parent_id = $product->get_parent_id();
		$product_child = 0;

		$product_id = intval($product->get_id());
		$product_price = $product->get_price();

		if($parent_id != 0){
			// variable got parent id
			$product_child = intval($_REQUEST['product_id']);
			$product_price = $product->get_price();
			$product = wc_get_product(intval($product->get_parent_id()));

			$product_id = intval($product->get_id());
		}

		// get cate
		$terms = get_the_terms ( $product_id, 'product_cat' );
		if(count($terms) > 0){
			$product_cates .= ' ( ';
			foreach ($terms as $index => $detailTerm) {
				$product_cates .= '(FIND_IN_SET("'.intval($detailTerm->term_id).'", cate_product) != 0 AND FIND_IN_SET("'.intval($detailTerm->term_id).'", cate_product) IS NOT NULL ) OR ';
			}
			$product_cates = substr($product_cates, 0, -4);
			$product_cates .= ' ) OR ';
		}

		// get product tags
		$terms = wp_get_post_terms( $product_id, 'product_tag' );
		if(count($terms) > 0){
			$product_tags .= ' ( ';
			foreach ($terms as $index => $detailTerm) {
				$product_tags .= '(FIND_IN_SET("'.intval($detailTerm->term_id).'", tags_product) != 0 AND FIND_IN_SET("'.intval($detailTerm->term_id).'", tags_product) IS NOT NULL ) OR ';
			}
			$product_tags = substr($product_tags, 0, -4);
			$product_tags .= ' ) OR ';
		}
		
		// get product list
		$product_query = '(FIND_IN_SET("'.intval($product_id).'", product_list) != 0 AND FIND_IN_SET("'.intval($product_id).'", product_list) IS NOT NULL ) OR ';

		// check query 
		if($product_tags != '' || $product_cates != '' || $product_query != ''){
			$container = substr($product_query.$product_tags.$product_cates, 0, -4);
		}
		
		$query = "SELECT * FROM {$lumise->db->prefix}price_discount WHERE active = 1 AND show_table = 1 AND (".$container.")";
		$datas = $lumise->db->rawQuery($query);

		if(count($datas) == 0){
			echo json_encode(array('status' => 0, 'message' => ''));
			die();
		}

		if($datas[0]['discount_rule'] == '' || $datas[0]['discount_rule'] == '[]'){
			echo json_encode(array('status' => 0, 'message' => ''));
			die();
		}

		$jsonData = json_decode(stripslashes($datas[0]['discount_rule']));
		if(empty($jsonData) || count($jsonData) == 0){
			echo json_encode(array('status' => 0, 'message' => ''));
			die();
		}

		usort($jsonData, array(&$this, 'cmp'));
		ob_start();
		?>
		<table class="show_table_discount_price" border="1">
			<thead>
				<th>Range</th>
				<th>price</th>
				<th>sale</th>
				<th>save</th>
			</thead>
			<tbody>
			<?php foreach ($jsonData as $index => $detail): ?>
				<tr>
					<td style="text-align: center;"><?php echo $detail->min_quantity.' - '.$detail->max_quantity; ?></td>
					<td class="lumise_price_base" style="text-align: center;"><?php echo wc_price($product_price); ?></td>
					<td class="lumise_price_sale" style="text-align: center;">
						<?php 
							if($detail->discount_type == 'percentage'){
								$calcDiscount = ((100-floatval($detail->discount_value))/100)*$product_price;
								echo wc_price($calcDiscount);
							}
							if($detail->discount_type == 'fixed'){
								$calcDiscount = $detail->discount_value;
								echo wc_price($calcDiscount);
							}
							if($detail->discount_type == 'minus_fixed' && floatval($detail->discount_value) < $product_price){
								$calcDiscount = doubleval($product_price) - doubleval($detail->discount_value);
								echo wc_price($calcDiscount);
							}
						?>
					</td>
					<td class="lumise_price_save" style="text-align: center;">
						<?php 
							if($detail->discount_type == 'percentage'){
								echo 'Save '.$detail->discount_value.'%';
							}
							if($detail->discount_type == 'fixed' && floatval($detail->discount_value) < $product_price){
								echo 'Save '.(($product_price - floatval($detail->discount_value))/100*100).'%';
							}
							if($detail->discount_type == 'minus_fixed' && floatval($detail->discount_value) < $product_price){
								echo 'Save '.(($product_price - floatval($detail->discount_value))/100*100).'%';
							}
						?>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
		<?php 
		$content = ob_get_contents();
		ob_clean();
		ob_end_flush();

		echo json_encode(array('status' => 1, 'message' => $content));
		die();
	}

	public function show_table(){
		echo '<div id="lumise_price_table_show"></div>';
	}

	public function cmp($a, $b) {
		if($a->min_quantity <= $b->min_quantity){
			return -1;
		}
		return 1;
	}

	public function lumise_calculate_totals($cart_object){
		foreach ($cart_object->cart_contents as $key => $value) {
			if(intval($value['variation_id']) != 0){
				// variable product
				$cart_item  = array('product_id' => intval($value['variation_id']), 'quantity' => intval($value['quantity']));
			}

			if(intval($value['variation_id']) == 0){
				// simple product
				$cart_item = array('product_id' => intval($value['product_id']), 'quantity' => intval($value['quantity']));
			}
			
			// $price = $value['data']->price;
			$lumise_price = $this->productDiscountCalc($cart_item);
			if($lumise_price == false){
				return;
			}
			$value['data']->set_price($lumise_price);
		}
	}

	public function lumise_mini_cart_price($output, $cart_item, $cart_item_key){
		if(empty($cart_item)){
			return $output;
		}
		$discountValue = $this->checkProductDiscount($output, $cart_item, 'mini_cart');
		if( $discountValue == false){
			return $output;
		}
		return $discountValue;
	}

	public function checkProductDiscount($output, $cart_item, $type = ''){
		global $lumise;

		$product_tags = '';
		$product_tag_list = array();
		$product_cates = '';
		$product_cate_list = array();
		$product_query = '';
		$container = '';

		$product_id = intval($cart_item['product_id']);

		// get cate
		$terms = get_the_terms ( $product_id, 'product_cat' );
		if(count($terms) > 0){
			$product_cates .= ' ( ';
			foreach ($terms as $index => $detailTerm) {
				$product_cates .= '(FIND_IN_SET("'.intval($detailTerm->term_id).'", cate_product) != 0 AND FIND_IN_SET("'.intval($detailTerm->term_id).'", cate_product) IS NOT NULL ) OR ';
			}
			$product_cates = substr($product_cates, 0, -4);
			$product_cates .= ' ) OR ';
		}

		// get product tags
		$terms = wp_get_post_terms( $product_id, 'product_tag' );
		if(count($terms) > 0){
			$product_tags .= ' ( ';
			foreach ($terms as $index => $detailTerm) {
				$product_tags .= '(FIND_IN_SET("'.intval($detailTerm->term_id).'", tags_product) != 0 AND FIND_IN_SET("'.intval($detailTerm->term_id).'", tags_product) IS NOT NULL ) OR ';
			}
			$product_tags = substr($product_tags, 0, -4);
			$product_tags .= ' ) OR ';
		}
		
		// get product list
		$product_query = '(FIND_IN_SET("'.$product_id.'", product_list) != 0 AND FIND_IN_SET("'.$product_id.'", product_list) IS NOT NULL ) OR ';

		// check query 
		if($product_tags != '' || $product_cates != '' || $product_query != ''){
			$container = substr($product_query.$product_tags.$product_cates, 0, -4);
		}
		
		$query = "SELECT * FROM {$lumise->db->prefix}price_discount WHERE active = 1 AND (".$container.")";
		$datas = $lumise->db->rawQuery($query);

		if(count($datas) == 0){
			return false;
		}
		return $this->calcPrice($datas[0], $cart_item, $output, $type);
	}

	public function calcPrice($calcPrice, $cart_item, $output, $type = ''){
		$decodePriceDiscountRule = json_decode(stripslashes($calcPrice['discount_rule']));

		$product = wc_get_product($cart_item['product_id']);
		$price = $product->get_price();

		if(isset($cart_item['variation_id']) && intval($cart_item['variation_id']) != 0){
			$product = wc_get_product(intval($cart_item['variation_id']));
			$price = $product->get_price();
		}

		foreach ($decodePriceDiscountRule as $index => $detailDiscountRule) {

			// mini cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $type == 'mini_cart' ){
				return $output;
			}

			// percentage calc detail cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $detailDiscountRule->discount_type == 'percentage' && $type == 'cart' ){
				$total_price = ((100-floatval($detailDiscountRule->discount_value))/100)*$price;
				return "<span style='color:#a3a3a3; text-decoration: line-through; font-size: 13px;'>".$product->get_price_html()."</span>"." <span style='color:red;'>".wc_price($total_price).'</span>';
			}

			// fixed calc detail cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $detailDiscountRule->discount_type == 'fixed' && $type == 'cart' ){
				return "<span style='color:#a3a3a3; text-decoration: line-through; font-size: 13px;'>".$product->get_price_html()."</span>"." <span style='color:red;'>".wc_price($detailDiscountRule->discount_value).'</span>';
			}

			// fixed minus calc detail cart
			if(intval($cart_item['quantity']) >= intval($detailDiscountRule->min_quantity) && intval($cart_item['quantity']) <= intval($detailDiscountRule->max_quantity) && $detailDiscountRule->discount_type == 'minus_fixed' && $type == 'cart' ){
				return "<span style='color:#a3a3a3; text-decoration: line-through; font-size: 13px;'>".$product->get_price_html()."</span>"." <span style='color:red;'>".wc_price(doubleval($price) - doubleval($detailDiscountRule->discount_value)).'</span>';
			}
		}

		return false;
	}

	public function lumise_cart_price($output, $cart_item, $cart_item_key){
		if(empty($cart_item)){
			return $output;
		}
		$discountValue = $this->checkProductDiscount($output, $cart_item, 'cart');
		if( $discountValue == false){
			return $output;
		}
		return $discountValue;
	}
	
	// active action
	static function active() {

		global $lumise;
		
		$lumise->db->rawQuery("CREATE TABLE IF NOT EXISTS `".$lumise->db->prefix."price_discount` (  
			`id` INT NOT NULL AUTO_INCREMENT,
			`name` TEXT DEFAULT NULL,
			`discount_type` VARCHAR(255) DEFAULT 'quantity',
			`product_list` TEXT DEFAULT NULL,
			`tags_product` TEXT DEFAULT NULL,
			`cate_product` TEXT DEFAULT NULL,
			`discount_rule` TEXT DEFAULT NULL,
			`active` INT(1) DEFAULT 1,
			`show_table` INT(1) DEFAULT 0,
			`created` datetime DEFAULT NULL,
			`updated` datetime DEFAULT NULL,
			`author` varchar(255) DEFAULT NULL,
			PRIMARY KEY (`id`)
		) CHARSET=utf8 COLLATE=utf8_general_ci;");
		
		$lumise->db->rawQuery("ALTER TABLE `".$lumise->db->prefix."price_discount` MODIFY `author` VARCHAR(255) NOT NULL DEFAULT ''");
		$lumise->db->rawQuery("UPDATE `".$lumise->db->prefix."price_discount` SET `author` = '{$lumise->vendor_id}'");
	}
	
	// deactive action
	static function deactive() {
		global $lumise;
	}
}
