(function($) {
	gettablePrice(my_ajax_object.product_id);

	// only work if exist
	if(my_ajax_object.is_variable_product && $('form[data-product_id="'+my_ajax_object.product_id+'"]').length == 1){
		var variable_data = JSON.parse($('form[data-product_id="'+my_ajax_object.product_id+'"]').attr('data-product_variations'));

		// everything variable change, check
		$(document).on('change', 'form[data-product_id="'+my_ajax_object.product_id+'"] select', function(){
			check_variable();
		});
	}

	function check_variable(){
		
		var list_variable_product = {};
		// get list variable selected
		$('form[data-product_id="'+my_ajax_object.product_id+'"] select').each(function(){
			var attribute_name = $(this).attr('data-attribute_name');
			var attribute_value = $(this).val();
			list_variable_product[attribute_name] = $(this).val();
		});

		// console.log(list_variable_product);
		// check variable with list selected
		$.each(variable_data, function(index, detail){
			// list attribute
			if(detail.attributes && JSON.stringify(detail.attributes) === JSON.stringify(list_variable_product)){
				gettablePrice(detail.variation_id);
			}
		});
	}

	function gettablePrice(product_id){
		$.ajax({
            url: my_ajax_object.ajax_url,
            dataType: "json",
            type: 'POST',
            // async: true,
            // cache: false,
            data: {
               action: 'lumise_show_table_price',
               product_id: product_id
            },
            success: function(result) {
                var html = '';
                if(result.status == 0){
                    html = result.message;
                }
                if(result.status == 1){
                	html = result.message;
                }
                $('#lumise_price_table_show').html(html);
            }
        });
	}

})(jQuery);