jQuery( function( $ ) {

  /**
   * get qty element.
   *
   * @type {string}
   */
  var qty_element = '.qty';

  /**
   * WPC Composite plugin
   */
  if( $( '.wooco_component_product_qty_input' ).length ) {
    var qty_element = 'form.cart .qty';
  }

  /**
   * Theme compatibilites.
   * Avada theme
   */
  if( $( '.custom-qty' ).length > 0 ) {
      qty_element = '.custom-qty';
  }

  /**
   * Enfold theme
   */
  if( $( '.custom-qty' ).length > 0 ) {
    qty_element = '.custom-qty';
  }

  /**
   * Erado theme
   */
  if( $( '.tc' ).length > 0 ) {
    qty_element = '.tc';
  }

  /**
   * Handle totals for variable products.
   */
  if ( $( '.single_variation_wrap' ).length ) {

    $( '.single_variation_wrap' ).on( 'show_variation', function ( event, variation ) {
      $( qty_element ).change();
    } );

    if ( $( '.bm-price-totals' ).length ) {
      var mut = new MutationObserver(function( mutations) {
        mutations.forEach( function( mutationRecord ) {
          if ( mutationRecord.target.classList.contains('disabled') ) {
            $( '.bm-price-totals' ).hide();
          } else {
            $( '.bm-price-totals' ).show();
          }
        })
      });

      var target = $( '.single_variation_wrap button[type=submit]' )[ 0 ];

      mut.observe( target ,{
        'attributes': true
      });
    }
  }

  /**
   * Updating the price markup.
   *
   * @param price_data price array
   * @param exclude    exclude css class
   *
   * @return void
   */
  $.fn.updatePrice = function( price_data, exclude = '' ) {
    /**
     * Check for sale price.
     */
    if ( $( this ).find( '.price > ins' ).length ) {
      /**
       * Germanized check.
       */
      if ( exclude != '' ) {
        $( this ).find( '.price:not(' + exclude + ') ins > .amount' ).replaceWith( price_data[ 'price' ] );
      } else {
        $( this ).find( '.price > ins > .amount' ).replaceWith( price_data[ 'price' ] );
      }
    } else {
      /**
       * Germanized check.
       */
      if ( exclude != '' ) {
        if( $( '.woocommerce-variation' ).length ) {
          $( this ).find( '.woocommerce-variation .price:not(' + exclude + ') > .amount' ).replaceWith( price_data[ 'price' ] );
        } else {
          $( this ).find( '.price:not(' + exclude + ') > .amount' ).replaceWith( price_data[ 'price' ] );
        }
      } else {
        $( this ).find( '.price > .amount' ).replaceWith( price_data[ 'price' ] );
      }
    }
    /**
     * Update ppu.
     */
    if ( $( this ).find( '.price-per-unit .amount' ).length && '' != price_data[ 'ppu' ] ) {
      /**
       * Germanized check.
       */
      if ( ! $( this ).find( '.price' ).hasClass( 'wc-gzd-additional-info' ) ) {
        if ( $( '.woocommerce-variation-price' ).length ) {
          $( this ).find( '.woocommerce-variation-price .price-per-unit .amount' ).replaceWith( price_data[ 'ppu' ] );
        } else {
          $( this ).find( '.price-per-unit .amount' ).replaceWith( price_data[ 'ppu' ] );
        }
      }
    }
  };

  /**
   * B2B Bulk Price table
   */
  let bulk_price_table_selector         = '.' + bm_update_price.bulk_price_table_class;
  let bulk_price_table_pick_min_max_qty = bm_update_price.bulk_price_table_pick_min_max_qty;

  if ( 'min' != bulk_price_table_pick_min_max_qty && 'max' != bulk_price_table_pick_min_max_qty ) {
    bulk_price_table_pick_min_max_qty = 'min';
  }

  let bulk_table_rows  = null;
  let background_color = bm_update_price.bulk_price_table_bg_color;
  let font_color       = bm_update_price.bulk_price_table_font_color;
  let quantity_field   = null;

  /**
   * Updating the colors in bulk price table.
   *
   * @return void
   */
  function updateBulkPriceTable() {
    let quantity = parseInt( $( quantity_field ).val() );
    /**
     * Walking through table rows.
     */
    $.each( $( bulk_table_rows ), function( key, row ){
      let bulk_quantity_from = parseInt( $( this ).find( 'td' ).eq( 1 ).text() );
      let bulk_quantity_to   = parseInt( $( this ).find( 'td' ).eq( 2 ).text() );
      if ( bulk_quantity_from <= quantity && ( bulk_quantity_to >= quantity || isNaN( bulk_quantity_to ) ) ) {
        $( row ).css({
          'background-color': background_color,
          'color': font_color,
        })
      } else {
        /**
         * Reset colors.
         */
        $( row ).css({
          'background-color': '',
          'color': '',
        })
      }
    } );
  }

  /**
   * Initalize all dynamic variables and set 'click' event.
   *
   * @return void
   */
  function handleBulkPriceTable() {
    if ( $( bulk_price_table_selector ).length ) {
      bulk_table_rows  = $( '.bm-bulk-table tbody > tr' );
      quantity_field   = $( 'form.cart input.qty' );

      $( bulk_table_rows ).css({
        cursor: 'pointer'
      });

      $( bulk_table_rows ).on( 'click', function() {
        let bulk_quantity_from = parseInt( $( this ).find( 'td' ).eq( 1 ).text() );
        let bulk_quantity_to   = parseInt( $( this ).find( 'td' ).eq( 2 ).text() );
        /**
         *  Reset colors.
         */
        $( bulk_table_rows ).css({
          'background-color': '',
          'color': '',
        });
        $( this ).css({
          'background-color': background_color,
          'color': font_color,
        });
        $( quantity_field ).val( ( isNaN( bulk_quantity_to ) || 'min' == bulk_price_table_pick_min_max_qty ) ? bulk_quantity_from : bulk_quantity_to );
        $( quantity_field ).change();
      } );

      updateBulkPriceTable();
    }
  }

  handleBulkPriceTable();

  /**
   * Observer for Variations with bulk prices
   */
  if ( $( '.single_variation_wrap' ).length ) {
    let product = $( '.single-product' );
    let price   = $( '.legacy-itemprop-offers' );
    product.on( 'found_variation', '.variations_form', function() {
      if ( $( '.woocommerce-variation-bulk-prices' ).length ) {
        handleBulkPriceTable();
      }
    } );
  }

  /**
   * Observer for Atomion Quickview,
   */
  if ( $( '#atomion-quick-view-modal' ).length ) {
    var target    = $( '#atomion-quick-view-modal' )[ 0 ];
    let triggered = false; // to prevent multiple js events on same elements

    var observer = new MutationObserver(function( mutations ) {
      mutations.forEach( function( mutation ) {
        if ( 'block' == $( target ).css( 'display' ) ) {
          var newNodes = mutation.addedNodes
          if ( newNodes !== null ) {
            if ( $( 'form.cart input.qty' ).length && ! triggered ) {
              handleBulkPriceTable();
              watchQtyInput();
              triggered = true;
              $( 'form.cart input.qty' ).change();
            }
          }
        } else {
          triggered = false;
        }
      });
    });

    var config = {
      attributes: true,
      childList: true,
      characterData: true,
    };

    observer.observe( target, config );
  }

  /**
   * Detecting quantity change and trigger price update.
   *
   * @return void
   */
  function watchQtyInput() {
    /**
     * Mmodify prices on quantity change.
     */
    $( qty_element ).on( 'change', function() {
      var id  = $( '#current_id' ).data( 'id' );
      var qty = $( this ).val();

      /**
       * check if variable product
       */
      if( $( '.variation_id' ).length > 0 ) {
        id = $( '.variation_id' ).val();
      }

      /**
       * Check if grouped product.
       */
      if( 'woocommerce-grouped-product-list-item__quantity' != $( qty_element ).parent().parent().attr( 'class' ) ) {
        /**
         * Get updated price with ajax.
         */
        $.ajax({
          type: 'POST',
          url: bm_update_price.ajax_url,
          data: {
            'action' : 'update_price',
            'id': id,
            'qty' : qty,
            'nonce' : bm_update_price.nonce
          },
          dataType: 'json',
          success: function( data ) {
            if ( 0 != data ) {
              if ( data[ 'price_value' ] > 0 ) {

                /**
                 * Trigger update Bulk Price Table row.
                 */
                if ( $( bulk_price_table_selector ).length ) {
                  updateBulkPriceTable();
                }

                /**
                 * WooCommerce Product Bundles
                 */
                if ( $( '.bundled_product' ).length > 0 ) {
                  if ( $( '.bundled_product' ).find( '.variations' ) ) {
                    return false;
                  }
                }

                /**
                 * Regular Markup & exclude Germanized CSS class by default
                 */
                if ( $( '.summary .price' ).length ) {
                  $( '.summary' ).updatePrice( data, '.wc-gzd-additional-info' );
                }

                /**
                 * Elementor.
                 */
                else if ( $( '.elementor-widget-container .price' ).length ) {
                  $( '.elementor-widget-container' ).updatePrice( data );
                }

                /**
                 * Avada.
                 */
                else if ( $( '.summary-container .price' ).length ) {
                  $( '.summary-container' ).updatePrice( data );
                  $('.summary-container .price-per-unit .amount').replaceWith(data['ppu']);
                }

                /**
                 * Divi.
                 */
                else if ( $('.et_pb_module_inner .price').length ) {
                  $( '.et_pb_module_inner' ).updatePrice( data );
                  $('.et_pb_module_inner .price-per-unit .amount').replaceWith(data['ppu']);
                }

                /**
                 * Avada mit Fusion Builder.
                 */
                else if ( $( '.fusion-woo-price-tb .price' ).length ) {
                  $( '.fusion-woo-price-tb' ).updatePrice( data );
                }

                /**
                 * Avada.
                 */
                else if ( $( '.summary-container .price' ).length ) {
                  $( '.summary-container' ).updatePrice( data );
                }

                /**
                 * Avada mit Fusion Builder.
                 */
                else if ( $( '.fusion-woo-price-tb .price' ).length ) {
                  $( '.fusion-woo-price-tb' ).updatePrice( data );
                }

                /**
                 * Uncode.
                 */
                else if ( $( '.uncont .price' ).length ) {
                  $( '.uncont' ).updatePrice( data );
                }

                /**
                 * Yootheme.
                 */
                else if ( $( '.uk-grid-item-match .price' ).length ) {
                  $( '.uk-grid-item-match' ).updatePrice( data );
                }

                /**
                 * some other themes.
                 */
                else if ( $( '.product-summary .price' ).length ) {
                  $( '.product-summary' ).updatePrice( data );
                  $( '.product-summary .price-per-unit .amount' ).replaceWith( data[ 'ppu' ] );
                }

                /**
                 * update ppu.
                 */

                //$('.product-summary .price-per-unit .amount').replaceWith(data['ppu']);

                /**
                 * Totals.
                 */
                if ( $( '.bm-price-totals' ).length ) {
                  if ( data[ 'totals' ] != '' ) {
                    $( '.bm-price-totals > span.totals-price' )
                      .empty()
                      .html( data[ 'totals' ] );
                  }
                  $( '.bm-price-totals' ).show();
                }

              }
            }
          }
        });
      }
      return false;
    });

    $( qty_element ).change();
  }

  watchQtyInput();

});
