<?php

/* Instanciate new Rapid Addon object */
$b2b_importer = new RapidAddon( 'B2B Market', 'b2b_market_importer' );

$args = array(
	'posts_per_page' => -1,
	'post_type'      => 'customer_groups',
);

$customer_groups = get_posts( $args );

$b2b_importer->add_field( 'bm_rrp', __( 'RRP Price', 'bm-wpai-addon' ), 'text', null, __( 'Add the RRP for the product. The value can be net or gross depending on your settings.', 'bm-wpai-addon' ) );

if ( isset( $customer_groups ) && ! empty( $customer_groups ) ) {
	foreach ( $customer_groups as $group ) {
		$b2b_importer->add_options(
			null,
			$group->post_title,
			array(
				$b2b_importer->add_field( 'bm_' . $group->post_name . '_group_prices', __( 'Group Prices', 'bm-wpai-addon' ), 'text', null, __( 'You need to enter your group prices in the following format: group_price/group_price_type(fix,discount or discount-percent). Multiple group price entries will be separated with |.', 'bm-wpai-addon' ) ),
				$b2b_importer->add_field( 'bm_' . $group->post_name . '_bulk_prices', __( 'Bulk Prices', 'bm-wpai-addon' ), 'text', null, __( 'You need to enter your bulk prices in the following format: bulk_price/from/to/bulk_price_type(fix,discount or discount-percent). Multiple bulk price entries will be separated with |.', 'bm-wpai-addon' ) ),
			)
		);
	}
}

/**
 * The importer function for B2B Market
 *
 * @param int    $post_id the current post id.
 * @param array  $data the current data array.
 * @param array  $import_options the options for the import.
 * @param object $article the current data object.
 * @return void
 */
function bmai_import_function( $post_id, $data, $import_options, $article ) {
	global $b2b_importer;

	/* get dynamic fields and fill in array */
	$fields = array();

	$args = array(
		'posts_per_page' => -1,
		'post_type'      => 'customer_groups',
	);

	$customer_groups = get_posts( $args );

	foreach ( $customer_groups as $group ) {
		$fields[] = 'bm_' . $group->post_name . '_group_prices';
		$fields[] = 'bm_' . $group->post_name . '_bulk_prices';
	}

	$fields[] = 'bm_rrp';

	foreach ( $fields as $field ) {

		if ( empty( $article['ID'] ) || $b2b_importer->can_update_meta( $field, $import_options ) ) {

			$product = wc_get_product( $post_id );

			if ( ! is_object( $product ) ) {
				return $field;
			}

			/* check if bulk field */
			if ( strpos( $field, '_bulk_prices' ) !== false ) {

				$bulk_prices = array();

				$bulk_price_sets = explode( '|', str_replace( ' ', '', $data[ $field ] ) );

				foreach ( $bulk_price_sets as $set ) {
					$bulk = explode( '/', $set );

					if ( ! empty( $bulk[0] ) && ! empty( $bulk[1] ) && isset( $bulk[2] ) && ! empty( $bulk[3] ) ) {
						$bulk_price = array(
							'bulk_price'      => str_replace( ',', '.', $bulk[0] ),
							'bulk_price_from' => $bulk[1],
							'bulk_price_to'   => $bulk[2],
							'bulk_price_type' => $bulk[3],
						);

						if ( isset( $bulk_price['bulk_price'] ) ) {
							$bulk_prices[] = $bulk_price;
						}
					}
				}

				if ( ! empty( $bulk_prices ) ) {
					update_post_meta( $post_id, $field, $bulk_prices );
				}
			} elseif ( strpos( $field, '_group_prices' ) !== false ) {
				$group_prices = array();

				$group_price_sets = explode( '|', str_replace( ' ', '', $data[ $field ] ) );

				foreach ( $group_price_sets as $set ) {
					$group = explode( '/', $set );

					if ( ! empty( $group[0] ) && ! empty( $group[1] ) ) {
						$group_price = array(
							'group_price'      => str_replace( ',', '.', $group[0] ),
							'group_price_type' => $group[1],
						);

						if ( ! empty( $group_price['group_price'] ) ) {
							$group_prices[] = $group_price;
						}
					}
				}
				if ( ! empty( $group_prices ) ) {
					update_post_meta( $post_id, $field, $group_prices );
				}
			} else {
				update_post_meta( $post_id, $field, $data[ $field ] );
			}
		}
	}
}


$b2b_importer->set_import_function( 'bmai_import_function' );
$b2b_importer->run();
