$( document ).ready(function($) {
    $(document).on('click', '.add_category', function() {
        let label = $(this).parent().find('.af2_add_category_input').val();

        $.ajax({
            url: af2_menu_components_object.ajax_url,
            type: "POST",
            data: { action: 'af2_add_category', label: label },
            success: () => { 
                window.location.href = af2_category_object.reload_url;
            },
            error: () => { }
        });
    });

    $(document).on('click', '.af2_category_delete', function() {
        let id = $(this).parent().attr('id');
        
        $.ajax({
            url: af2_menu_components_object.ajax_url,
            type: "POST",
            data: { action: 'af2_delete_category', id: id },
            success: () => { 
                window.location.href = af2_category_object.reload_url;
            },
            error: () => { }
        });
    });

    $(document).on('change', '.af2_category_selection', function() {
        let id = $(this).val();
        let elementid = $(this).attr('data-elementid');

        $.ajax({
            url: af2_menu_components_object.ajax_url,
            type: "POST",
            data: { action: 'af2_set_element_category', id: id, elementid: elementid },
            success: () => { 
                window.location.href = af2_category_object.reload_url_nomodal;
            },
            error: () => { }
        });
    });
});