$( document ).ready(function() {

    if(af2_menu_components_object.dark_mode == 1) {
         $('#wpbody-content').addClass('af2_background_color_dark');
         $('#wpbody').addClass('af2_background_color_dark');
    }

    // Darkmode
    $('#af2_toggle_dark_mode').on('click', function() {
        let checked = false;
        if ($(this).is(':checked')) checked = true;

        $('.af2_wrapper').toggleClass('af2_darkmode');

        if(checked) $('#wpbody-content').addClass('af2_background_color_dark');
        else $('#wpbody-content').removeClass('af2_background_color_dark');
        if(checked) $('#wpbody').addClass('af2_background_color_dark');
        else $('#wpbody').removeClass('af2_background_color_dark');

        $.ajax({
                url: af2_menu_components_object.ajax_url,
                type: "POST",
                data: { action: 'af2_trigger_dark_mode', state: checked },
                success: () => { },
                error: () => { }
        });
    });

    // Search Filter
    $('#af2_search_filter').on('input', function() {
        const filterText = $(this).val().toLowerCase();
        const searchFilterColumn = $(this).data('searchfiltercolumn');

        
        if(!searchFilterColumn.includes(';')) {
            const allFilterableTexts = $('.af2_post_table_content[data-searchfilter="'+searchFilterColumn+'"]');

            $(allFilterableTexts).each((i, el) => {
                const editElement = $(el).parent();
                const actualText = $(el).data('searchvalue') != null ? $(el).data('searchvalue').toLowerCase() : null;

                if(actualText == null) return;
    
                if(actualText.includes(filterText)) $(editElement).removeClass('af2_hide');
                else $(editElement).addClass('af2_hide');
            });
        }
        else {
            const rows = searchFilterColumn.split(';');
            const allFilterableRows = $('.af2_post_table_body .af2_post_table_row');

            $(allFilterableRows).each((i, el) => {
                const editElement = $(el);
                
                let allFilterableTexts = null;
                rows.forEach(ele => {
                    if(allFilterableTexts == null) allFilterableTexts = $('#'+$(el).attr('id')+'.af2_post_table_row .af2_post_table_content[data-searchfilter="'+ele+'"]');
                    else $.merge(allFilterableTexts, $('#'+$(el).attr('id')+'.af2_post_table_row .af2_post_table_content[data-searchfilter="'+ele+'"]'));
                });

                let show = false;
                $(allFilterableTexts).each((i, ele) => {
                    const actualText = $(ele).data('searchvalue') != null ? $(ele).data('searchvalue').toString().toLowerCase() : null;

                    if(actualText == null) return;
                    if(actualText.includes(filterText)) show = true;
                });

                if(show) $(editElement).removeClass('af2_hide');
                else $(editElement).addClass('af2_hide');                
            });
        }
        
    });

    $('.af2_choose_all_table_objects').on('click', function() {
        const val = $(this).is(':checked') ? true : false;
        $('.af2_choose_table_object').prop('checked', val);

        if($('.af2_choose_table_object:checked').length > 0) {
            $('#af2_copy_posts').removeClass('af2_hide');
            $('#af2_delete_posts').removeClass('af2_hide');
        }
        else {
            $('#af2_copy_posts').addClass('af2_hide');
            $('#af2_delete_posts').addClass('af2_hide');
        }
    });

    $('.af2_choose_table_object').on('click', function() {
        if($('.af2_choose_table_object:checked').length > 0) {
            $('#af2_copy_posts').removeClass('af2_hide');
            $('#af2_delete_posts').removeClass('af2_hide');
        }
        else {
            $('#af2_copy_posts').addClass('af2_hide');
            $('#af2_delete_posts').addClass('af2_hide');
        }

        if($('.af2_choose_table_object').not('.af2_choose_table_object:checked').length > 0) $('.af2_choose_all_table_objects').prop('checked', false);
        if($('.af2_choose_table_object:checked').length == $('.af2_choose_table_object').length) $('.af2_choose_all_table_objects').prop('checked', true);
    });
    
    $('#af2_copy_posts').on('click', function() {
        let ids = [];
        $('.af2_choose_table_object:checked').each((i, el) => {
            ids.push($(el).attr('id'));
        });
        $.ajax({
            url: af2_menu_components_object.ajax_url,
            type: 'POST',
            data: { action: 'af2_copy_posts', 'post_ids': ids },
            success: () => { window.location.reload(); },
            error: () => {}
        });
    });

    $('#af2_delete_posts').on('click', function() {
        let ids = [];
        $('.af2_choose_table_object:checked').each((i, el) => {
            if(!$(el).closest('.af2_post_table_row').hasClass('af2_hide')) {
                ids.push($(el).attr('id'));
            }
        });
        $.ajax({
            url: af2_menu_components_object.ajax_url,
            type: 'POST',
            data: { action: 'af2_delete_posts', 'post_ids': ids },
            success: () => { window.location.reload(); },
            error: () => {}
        });
    });

    $('.af2_menu_functions_select').on('change', function() {
        const val = $(this).val();

        window.location.href = $(this).data('link')+'&'+$(this).data('getattribute')+'='+val;
    });

    $(document).on('click', '.af2_copy_to_clipboard_es', function(e){
        let textId = this.dataset.id;
        let input = $(this).parent().find('#'+textId);
        input.focus();
    });
    $(document).on('focus', '.af2_copy_to_clipboard_element', function(e){
        af2_copy_to_clipboard(this);        
    });


    $(document).on('click', '.show_hide_helpcenter', function(e) {
        $('#af2_helpcenter_frame').toggleClass('af2_hide');

        if($('#af2_helpcenter_frame').hasClass('af2_hide')) {
            $('.show_hide_helpcenter i').removeClass('fa-times');
            $('.show_hide_helpcenter i').addClass('fa-question');
        } else {
            $('.show_hide_helpcenter i').removeClass('fa-question');
            $('.show_hide_helpcenter i').addClass('fa-times');
        }
    });

    function af2_copy_to_clipboard(element){
        element.select();
        element.setSelectionRange(0, 9999999);
        window.document.execCommand('copy');
        /* navigator.clipboard.writeText(element.value); */
        //$('[data-id="'+ element.id +'"]').append('<span class="copy-tip">Copied!</span>');
        //setTimeout(() => { $('[data-id="'+ element.id +'"]').find('.copy-tip').remove(); }, 3000);
    }
});
