$( document ).ready(function() {

	let buttonContent = '<i class="fas fa-file-import"></i>'+af2_demoimport_object.strings.import;
	let buttonContentLoad = '<span class="af2_hide loading">&nbsp;<i class="fas fa-circle-notch fa-spin"></i></span>';

    $(document).on('click', '.af2_import_file', function(e) {
		e.preventDefault();
        const selector = '#'+$(this).attr('id')+'.af2_import_file';
		if(!$('#af2_import_button').hasClass('af2_btn_disabled')) {
			$(selector).prop('disabled', true);
			$(selector).addClass('af2_btn_disabled');


			$(selector).html(buttonContent+' - '+af2_demoimport_object.strings.wait+buttonContentLoad);
			$(selector +' .loading').removeClass('af2_hide');

			$.ajax({
                url: af2_menu_components_object.ajax_url,
                type: "POST",
                data: { 
					action: 'af2_demoimport',
					filename: $(this).data('filename') 
				},
                success: (msg) => {
					$(selector).removeAttr('disabled'); 
					$(selector).removeClass('af2_btn_disabled'); 
					$(selector +' .loading').addClass('af2_hide');
					$(selector).html(af2_demoimport_object.strings.success); 
					$(selector).addClass('af2_succeed_import'); 

					setTimeout(_ => {
						window.location.reload();
					}, 1000);
				},
                error: () => { }
        	});
		}
	});

});