<?php

function create_timestamp() {
    $tz = 'Europe/Amsterdam';
    $timestamp = time();
    $dt = new DateTime("now", new DateTimeZone($tz));
    $dt->setTimestamp($timestamp);

    return $dt->format('YmdH');
}

function af_base64UrlEncode($inputStr)
{
    return strtr(base64_encode($inputStr), '+/=', '-_,');
}


function af_base64UrlDecode($inputStr)
{
    return base64_decode(strtr($inputStr, '-_,', '+/='));
}

function af_get_months_array(){
    return array(
        1 => __('January', 'af2_multilanguage' ),
        2 => __('February', 'af2_multilanguage' ),
        3 => __('March', 'af2_multilanguage' ),
        4 => __('April', 'af2_multilanguage' ),
        5 => __('May', 'af2_multilanguage' ),
        6 => __('June', 'af2_multilanguage' ),
        7 => __('July', 'af2_multilanguage' ),
        8 => __('August', 'af2_multilanguage' ),
        9 => __('September', 'af2_multilanguage' ),
        10 => __('October', 'af2_multilanguage' ),
        11 => __('November', 'af2_multilanguage' ),
        12 => __('December', 'af2_multilanguage' )
    );
}

function af2_get_post_content( $post ) {
    if(empty($post) || $post == null) return null;
    $post_content = get_post_field( 'post_content', $post );
    if(empty($post_content) || $post_content == null) return null;
    $post_content_array = unserialize(urldecode($post_content));
    $post_content_array = stripslashes_deep($post_content_array);

    return $post_content_array;
}

function af2_str_contains( $haystack, $needle ) {
    if(function_exists('str_contains')) return str_contains($haystack, $needle);
    else return strpos($haystack, $needle) !== false;
}