<?php

require_once AF2_INTEGRATION_HANDLER_CLASS;
class Klicktipp_Integration extends Af2Integration {

    public function get_credential_fields() {
        return array( 
            array( 'key' => 'user', 'option_value' => 'af2_klicktipp_user', 'icon' => 'fas fa-user-alt', 'label' => 'Username:', 'type' => 'text' ),
            array( 'key' => 'pw', 'option_value' => 'af2_klicktipp_pw', 'icon' => 'fas fa-key', 'label' => 'Password:', 'type' => 'password' ),
        );
    }

    public function is_active() { 
        $credentials = $this->get_credentials();

        if(!isset($credentials) || empty($credentials)) return false;
        if(!isset($credentials['user']) || empty($credentials['user'])) return false;
        if(!isset($credentials['pw']) || empty($credentials['pw'])) return false;

        return true;
    }

    public function get_api_values() { 
        return array(
            array( 'label' => 'mail', 'type' => 'contactform'),
            array( 'label' => 'anrede', 'type' => 'contactform'),
            array( 'label' => 'vorname', 'type' => 'contactform'),
            array( 'label' => 'name', 'type' => 'contactform'),
            array( 'label' => 'telefon', 'type' => 'contactform'),
            array( 'label' => 'firma', 'type' => 'contactform'),
            array( 'label' => 'tag', 'type' => 'field'),
            array( 'label' => 'process', 'type' => 'field'),
        ); 
    }

    public function get_api_draw_fields() { 
        return array(
            array(
                'label' => __('Contact information:', 'af2_multilanguage'),
                'fields' => array(
                    array( 'label' => __('E-mail', 'af2_multilanguage'), 'required' => true, 'type' => 'select', 'value' => 'mail' ),
                    array( 'label' => __('Salutation', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'anrede' ),
                    array( 'label' => __('First name', 'af2_multilanguage'), 'required' => true, 'type' => 'select', 'value' => 'vorname' ),
                    array( 'label' => __('Last name', 'af2_multilanguage'), 'required' => true, 'type' => 'select', 'value' => 'name' ),
                    array( 'label' => __('Phone', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'telefon' ),
                    array( 'label' => __('Company', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'firma' ),
                ),
            ),
            array(
                'label' => __('List data:', 'af2_multilanguage'),
                'fields' => array(
                    array( 'label' => __('Tag', 'af2_multilanguage'), 'required' => false, 'type' => 'select_', 'type_label' => 'tag', 'value' => 'tag' ),
                    array( 'label' => __('Double-Opt-In', 'af2_multilanguage'), 'required' => false, 'type' => 'select_', 'type_label' => 'process', 'value' => 'process' ),
                ),
            ),
        );
    }

    public function fetch_fields_from_api() { 
        $credentials = $this->get_credentials();
       
        $username = $credentials['user'];
        $password = $credentials['pw'];

        require_once AF2_INTEGRATION_DIR.'/Klicktipp/klicktipp.api.inc';
        
        $connector = new WPF_KlicktippConnector(); 
        $connector->login($username, $password); 
        
        $tags = array();
        $processes = array();

        $proc = $connector->subscription_process_index();
        $tag = $connector->tag_index();

        foreach($proc as $var => $value) {
            $save_label = $value != '' ? $value : __('standard', 'af2_multilanguage');
            $save_val = $var;
            
            array_push($processes, array('value' => $save_val, 'label' => $save_label));
        }
        foreach($tag as $var => $value) {
            $save_label = $value != '' ? $value : __('standard', 'af2_multilanguage');
            $save_val = $var;
            
            array_push($tags, array('value' => $save_val, 'label' => $save_label));
        }

        $connector->logout();

        return array(
            'tag' => $tags,
            'process' => $processes,
        );
    }

    public function send_to_api() {
        $credentials = $this->get_credentials();

        $fields = array(// Use field_index to get all custom fields.
            'fieldFirstName' => $this->api_values['vorname'],
            'fieldLastName' => $this->api_values['name'],
            'fieldPrivatePhone' => $this->api_values['telefon'],
            'fieldCompanyName' => $this->api_values['firma']
        );

        $username = $credentials['user'];
        $password = $credentials['pw'];
        $email_address = $this->api_values['mail'];

        $double_optin_process_id = $this->api_values['process'];
        $tag_id = $this->api_values['tag'];

        require_once AF2_INTEGRATION_DIR.'/Klicktipp/klicktipp.api.inc';
        
        $connector = new WPF_KlicktippConnector(); 
        $connector->login($username, $password); 
        $subscriber = $connector->subscribe($email_address, $double_optin_process_id, $tag_id, $fields); 
        $connector->logout();
    }
}
