<?php

require_once AF2_INTEGRATION_HANDLER_CLASS;
class FinCRM_Integration extends Af2Integration {

    public function get_credential_fields() {
        return array( 
            array( 'key' => 'id', 'option_value' => 'af2_fincrm_id', 'icon' => 'fas fa-user-alt', 'label' => 'User ID:', 'type' => 'text' ),
            array( 'key' => 'api_key', 'option_value' => 'af2_fincrm_token',  'icon' => 'fas fa-key', 'label' => 'API Key:', 'type' => 'password'  ),
        );
    }

    public function is_active() { 
        $credentials = $this->get_credentials();

        if(!isset($credentials) || empty($credentials)) return false;
        if(!isset($credentials['id']) || empty($credentials['id'])) return false;
        if(!isset($credentials['api_key']) || empty($credentials['api_key'])) return false;

        return true;
    }

    public function get_api_values() { 
        return array(
            array( 'label' => 'email', 'type' => 'contactform'),
            array( 'label' => 'first_name', 'type' => 'contactform'),
            array( 'label' => 'last_name', 'type' => 'contactform'),
            array( 'label' => 'salutation', 'type' => 'contactform'),
            array( 'label' => 'phone_office', 'type' => 'contactform'),
            array( 'label' => 'phone_private', 'type' => 'contactform'),
            array( 'label' => 'mobile', 'type' => 'contactform'),
        ); 
    }

    public function get_api_draw_fields() { 
        return array(
            array(
                'label' => __('Contact information:', 'af2_multilanguage'),
                'fields' => array(
                    array( 'label' => __('E-mail', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'email' ),
                    array( 'label' => __('First name', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'first_name' ),
                    array( 'label' => __('Last name', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'last_name' ),
                    array( 'label' => __('Salutation', 'af2_multilanguage'), 'required' => true, 'type' => 'select', 'value' => 'salutation' ),
                    array( 'label' => __('Phone office', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'phone_office' ),
                    array( 'label' => __('Phone private', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'phone_private' ),
                    array( 'label' => __('Phone mobile', 'af2_multilanguage'), 'required' => false, 'type' => 'select', 'value' => 'mobile' ),
                ),
            ),
        );
    }

    public function send_to_api() { 
        $credentials = $this->get_credentials();

        $fincrm_user_id = $credentials['id'];
        $fincrm_token = $credentials['api_key'];

        $fincrm_answers = $this->api_values['answer_string'];

        $fincrm_fields = [
            'email' => $this->api_values['email'],
            'first_name' => $this->api_values['first_name'],
            'last_name' => $this->api_values['last_name'],
            'salutation' => $this->api_values['salutation'],
            'phone_office' => $this->api_values['phone_office'],
            'phone_private' => $this->api_values['phone_private'],
            'mobile' => $this->api_values['mobile'],
        ];


        $fincrm_customer_json = json_decode($this->finCreateNewCustomer($fincrm_user_id, $fincrm_token, $fincrm_fields));

        if( isset($fincrm_customer_json->code) || isset($fincrm_customer_json->message) || isset($fincrm_customer_json->errors) ) {

        } else if(isset($fincrm_customer_json->id)) {
            $fincrm_id = $fincrm_customer_json->id;

            $fincrm_fields2 = [
                'text' => $fincrm_answers,
            ];

            $this->finCreateNewNote($fincrm_user_id, $fincrm_token, $fincrm_id, $fincrm_fields2);
        }
    }

    function finCreateNewNote($customer_id, $token, $customerId, $fields) {
        $url = "https://{$customer_id}.fincrm.de/api/v1/customers/{$customerId}/notes";
    
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);
        
        $headers = array(
           "Accept: application/json",
           "Authorization: Bearer {$token}",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        //for debug only!
        //curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $resp = curl_exec($curl);
        curl_close($curl);
    
        return $resp;
    }

    function finCreateNewCustomer($customer_id, $token, $fields) {
        $url = "https://{$customer_id}.fincrm.de/api/v1/customers";
    
        $curl = curl_init($url);
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $fields);
        
        $headers = array(
           "Accept: application/json",
           "Authorization: Bearer {$token}",
        );
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        //for debug only!
        //curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
        //curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        
        $resp = curl_exec($curl);
        curl_close($curl);
    
        return $resp;
    }
    
}