<?php $locale = get_locale(); ?>
<div class="af2_menu_sheet_sidebar af2_card">
    <div class="af2_card_block">
        <h4><?=__('Introduction video', 'af2_multilanguage')?></h4>
        <p><?=__('Check out the introduction video to get a quick overview of all the features!', 'af2_multilanguage')?></p>
        <div data-target="introduction_video" class="af2_btn af2_btn_primary af2_modal_btn mt20"><i class="fas fa-play-circle"></i><?=__('Watch video', 'af2_multilanguage')?></div>
    </div>
    <div class="af2_card_divider"></div>
    <div class="af2_card_block">
        <h4><?=__('Need help?', 'af2_multilanguage')?></h4>
        <p><?=__('The question mark at the bottom right will take you to the Help Center!', 'af2_multilanguage')?></p>
        <a class="af2_btn_link" href="https://help.funnelforms.io/" target="_blank">
            <div class="af2_btn af2_btn_secondary mt20"><i class="fas fa-headset"></i><?=__('Help center', 'af2_multilanguage')?></div>
        </a>
    </div>
    <div class="af2_card_divider"></div>
    <div class="af2_card_block">
        <h4><?=__('Feature requests', 'af2_multilanguage')?></h4>
        <p><?=__('Develop Funnelforms together with us and share your ideas and wishes here!', 'af2_multilanguage')?></p>
        <?php 
            $featureupvote_link = '';
            switch($locale) {
                case 'de_DE': {
                    $featureupvote_link = 'https://feedback.funnelforms.io/b/funnelforms-deutsch/';
                    break;
                }
                default: {
                    $featureupvote_link = 'https://feedback.funnelforms.io/b/funnelforms-english/';
                    break;
                }
            }
        ?>
        <a class="af2_btn_link" href="<?=$featureupvote_link?>" target="_blank">
            <div class="af2_btn af2_btn_secondary mt20"><i class="fas fa-vote-yea"></i><?=__('Feature voting', 'af2_multilanguage')?></div>
        </a>
    </div>
    <div class="af2_card_divider"></div>
    <div class="af2_card_block">
        <div class="af2_toggle_wrapper mb10">
            <input type="checkbox" id="af2_toggle_dark_mode" class="af2_toggle" <?=get_option('af2_dark_mode') == 1 ? 'checked' : ''?>>
            <label for="af2_toggle_dark_mode" class="af2_toggle_btn"></label>
            <h4 class="af2_toggle_label ml5"><?=__('Dark Mode', 'af2_multilanguage')?></h4>
        </div>
        <p><?=__('Activate the dark mode within the plugin!', 'af2_multilanguage')?></p>
    </div>
</div>


<div id="introduction_video" class="af2_modal" 
    data-heading="<?=__('Introduction video', 'af2_multilanguage')?>"
    data-close="<?=__('Close', 'af2_multilanguage')?>">
    
  <!-- Modal content -->
  <div class="af2_modal_content">
    <div style="padding:56.43% 0 0 0;position:relative;"><iframe src="https://player.vimeo.com/video/712847126?h=dc86c9e5ef&amp;badge=0&amp;autopause=0&amp;player_id=0&amp;app_id=58479" frameborder="0" allow="autoplay; fullscreen; picture-in-picture" allowfullscreen style="position:absolute;top:0;left:0;width:100%;height:100%;" title="Quick-Start-Guide-Pro.mp4"></iframe></div><script src="https://player.vimeo.com/api/player.js"></script>
  </div>

</div>