<div class="af2_lizenz_wrapper">
    <div class="af2_card">
        <form id="af2_lizenz" name="af2_license_form" enctype="multipart/form-data">
            <div class="af2_card_block">
                <div class="af2_license_block">
                    <h4><?=__('License key', 'af2_multilanguage')?></h4>
                    <p><?=get_option('af2_license_stat') == 'Die Domain ist aktiviert!' ? __('The domain is activated!', 'af2_multilanguage') : __(get_option('af2_license_stat'), 'af2_multilanguage')?></p>
                    <div id="license_form" class="custom_builder_content_card_box">
                        <div class="custom_builder_content_card_box_heading">
                            <i class="fas fa-key"></i>
                            <p><?=__('License key', 'af2_multilanguage')?></p>
                        </div>
                        <div class="custom_builder_content_card_box_content">
                            <input type="text" placeholder="..." class="af2_edit_content_input" value="<?=get_option('af2_license_key')?>">
                        </div>
                    </div>
                </div>
                <button disabled type="submit" id="af2_save_license_button" class="af2_btn af2_btn_primary af2_btn_disabled"><i class="fas fa-search"></i><?=__('Check license', 'af2_multilanguage')?>
                    <span class="af2_hide loading">&nbsp;<i class="fas fa-circle-notch fa-spin"></i></span>
                </button>
                <a href="https://member.funnelforms.io/lizenzschluessel/" target="_blank" class="af2_btn_link">
                    <div class="af2_btn af2_btn_primary"><i class="fas fa-cogs"></i><?=__('Manage licenses and domain', 'af2_multilanguage')?></div>
                </a>
            </div>
        </form>
    </div>
    
    <div class="af2_card">
        <form id="af2_app" name="af2_app_form" enctype="multipart/form-data">
            <div class="af2_card_block">
                <div class="af2_license_block">
                    <h4><?=__('App', 'af2_multilanguage')?></h4>
                    <?php if(get_option('af2_registered_app_code') == '') { ?>
                        <p><?=__('Scan the QR code with the Funnelforms app:', 'af2_multilanguage')?></p>
                        <div id="license_form" class="custom_builder_content_card_box">
                            <img class="af2_app_image" src="<?=get_option('app_qr_code');?>" title="Verknüpfe die App" />
                        </div>
                    <?php } else { ?>
                        <p><?=__('The app is linked with:', 'af2_multilanguage')?> <?=get_option('af2_registered_app_device')?></p>
                        <div id="license_form" class="custom_builder_content_card_box">
                        <button type="submit" id="af2_delete_app_button" class="af2_btn af2_btn_primary"><i class="fas fa-times"></i><?=__('Unlink app', 'af2_multilanguage')?>
                            <span class="af2_hide loading">&nbsp;<i class="fas fa-circle-notch fa-spin"></i></span>
                        </button>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </form>
    </div>
</div>

<div id="af2_lizenz_modal" class="af2_modal"
    data-class="af2_lizenz_modal"
    data-target="af2_lizenz_modal"
    data-sizeclass="moderate_size"
    data-bottombar="true"
    data-heading="<?=__('License', 'af2_multilanguage')?>"
    data-close="<?=__('Close', 'af2_multilanguage')?>">

    <!-- Modal content -->
    <div class="af2_modal_content">

    </div>
    
    <div class="af2_modal_bottombar">
        <div class="af2_btn af2_btn_primary">
            <a id="af2_checklist_link" class="af2_btn_link" href="<?= admin_url( '/admin.php?page='.CHECKLIST_SLUG ) ?>"><?=__('First steps', 'af2_multilanguage')?></a>
        </div>
    </div>
</div>
<div id="af2_app_modal" class="af2_modal"
    data-class="af2_app_modal"
    data-target="af2_app_modal"
    data-sizeclass="moderate_size"
    data-bottombar="false"
    data-heading="<?=__('App', 'af2_multilanguage')?>"
    data-close="<?=__('Close', 'af2_multilanguage')?>">

    <!-- Modal content -->
    <div class="af2_modal_content">
        <?=__('App unlinked', 'af2_multilanguage')?>
    </div>
</div>