<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2KontaktformularbuilderSettings extends Af2MenuBuilder {

    protected function get_builder_heading() { return array('label' => 'Contact form editor', 'icon' => 'fas fa-edit'); }
    protected function get_builder_template() { return AF2_BUILDER_TEMPLATE_KONTAKTFORMULAR_SETTINGS; }
    protected function get_builder_sidebar_edit_() { return array('label' => 'Settings'); }
    protected function get_menu_builder_control_buttons_() { return array(array('id' => 'af2_goto_kontaktformularbuilder', 'icon' => 'fas fa-cog', 'label' => 'Back to Editor')); }

    protected function get_close_editor_url() { return admin_url('/admin.php?page='.KONTAKTFORMULAR_SLUG ); }

    protected function get_builder_script() { return 'af2_kontaktformularbuilder_settings'; }
    protected function get_builder_style() { return 'af2_kontaktformularbuilder_settings_style'; }
    protected function get_builder_script_object_name() { return 'af2_kontaktformularbuilder_settings_object';  }
    protected function get_builder_script_localize_array() { 
        return array(
            'redirect_kontaktformularbuilder_url' => admin_url('/admin.php?page='.KONTAKTFORMULARBUILDER_SLUG.'&id='.$_GET['id'] ),
            'wordpress_mail_url' => 'wordpress@'.parse_url(get_site_url(), PHP_URL_HOST),
            'page_title' => get_option('blogname'),
            'ajax_url' => admin_url('admin-ajax.php'),
            'strings' => array(
                'id_tag' => __('[ID]', 'af2_multilanguage'),
                'answers_tag' => __('[ANTWORTEN]', 'af2_multilanguage'),
                'terminname_tag' => __('[TERMINNAME]', 'af2_multilanguage'),
                'termindauer_tag' => __('[TERMINDAUER]', 'af2_multilanguage'),
                'terminzeit_tag' => __('[TERMINZEIT]', 'af2_multilanguage'),
                'termindatum_tag' => __('[TERMINDATUM]', 'af2_multilanguage'),
                'querystring_tag' => __('[QUERYSTRING]', 'af2_multilanguage'),
                'code_tag' => __('[CODE]', 'af2_multilanguage'),
                'url_tag' => __('[URL]', 'af2_multilanguage'),
                'name_placeholder' => __('Your name...', 'af2_multilanguage'),
                'mail_placeholder' => __('Your e-mail...', 'af2_multilanguage'),
                'phone_placeholder' => __('Your phone number...', 'af2_multilanguage'),
                'checkbox_text' => __('I accept the privacy policy', 'af2_multilanguage'),
                'name' => __('name', 'af2_multilanguage'),
                'mail' => __('mail', 'af2_multilanguage'),
                'telefon' => __('phone', 'af2_multilanguage'),
                'checkbox' => __('checkbox', 'af2_multilanguage'),
                'send_form' => __('Submit form', 'af2_multilanguage'),
                'subject' => __('New Lead', 'af2_multilanguage'),
                'testnachricht' => __('Click here to view the test message log', 'af2_multilanguage'),
            ),

        );
    }

    protected function get_af2_builder_custom_contents_() {
        $messagebird_active = false;


        $post = get_post($_GET['id']);
        $post_content = unserialize(urldecode(get_post_field( 'post_content', $post )));

        if(isset($post_content['questions'])) { 
            foreach($post_content['questions'] as $question) {
                if($question['typ'] == 'text_type_phone_verification') $messagebird_active = true;
            }
        }

        return array(
            'messagebird_active' => $messagebird_active,
        );
    }

    protected function get_builder_sidebar_edit_elements_() {
        require_once AF2_MENU_KONTAKTFORMULARBUILDER_SETTINGS_ELEMENTS_PATH;
        return get_kontaktformularbuilder_settings_elements();
    }

    protected function load_resources() {
        require_once AF2_RESOURCE_HANDLER_PATH;
        load_media_iconpicker();

        parent::load_resources();
    }


    public static function save_function($content) {
        require_once AF2_MISC_FUNCTIONS_PATH;
        $own_content = $content;
        $echo_content = array();


        if(!isset($own_content['cftitle']) || empty($own_content['cftitle'])) {
            array_push($echo_content, array('label' => __('No contact form title (frontend) specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
        }

        if(!isset($own_content['send_button']) || empty($own_content['send_button'])) {
            array_push($echo_content, array('label' => __('No button text specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
        }

        if(!isset($own_content['name']) || empty($own_content['name'])) {
            array_push($echo_content, array('label' => __('No contact form title (backend) specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_contact_form_backend_heading'));
        }

        if(isset($own_content['questions'])) {
            $i = 0;

            $ids_array = array();

            $messagebird_count = 0;

            foreach($own_content['questions'] as $question) {
                if(!isset($question['id']) || empty($question['id'])) {
                    array_push($echo_content, array('label' => __('All elements must have an ID!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
                }
                else if($question['typ'] == 'salutation_type') {
                   if(
                        (!filter_var($question['allowSalutationCompany'], FILTER_VALIDATE_BOOLEAN)) &&
                        (!filter_var($question['allowSalutationDivers'], FILTER_VALIDATE_BOOLEAN)) &&
                        (!filter_var($question['allowSalutationFemale'], FILTER_VALIDATE_BOOLEAN)) &&
                        (!filter_var($question['allowSalutationMale'], FILTER_VALIDATE_BOOLEAN))
                    ) {
                        array_push($echo_content, array('label' => __('At least one field must be displayed for the salutation!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
                    }
                }
                else if($question['typ'] == 'google_recaptcha') {
                    if(!isset($question['site_key']) || empty($question['site_key'])) {
                        array_push($echo_content, array('label' => __('The site key must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
                    }
                    if(!isset($question['site_secret']) || empty($question['site_secret'])) {
                        array_push($echo_content, array('label' => __('The secret key must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
                    }
                }
                if($question['typ'] == 'text_type_phone_verification') $messagebird_count++;

                if(in_array($question['id'], $ids_array)) {
                    array_push($echo_content, array('label' => __('An ID cannot be assigned twice!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_kontaktformularbuilder'));
                }
                array_push($ids_array, $question['id']);
                $i++;
            }

            if($messagebird_count > 0) {
                if(!isset($own_content['smsSender']) || empty($own_content['smsSender'])) {
                    array_push($echo_content, array('label' => __('An SMS sender must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smsSender"]'));
                }
                if(!isset($own_content['smsText']) || empty($own_content['smsText'])) {
                    array_push($echo_content, array('label' => __('An SMS message must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smsText"]'));
                }
                else if(!af2_str_contains(strtolower($own_content['smsText']), strtolower(__('[CODE]', 'af2_multilanguage')))) {
                    array_push($echo_content, array('label' => __('The code is not passed in the SMS message!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smsText"]'));
                }

                if($messagebird_count > 1) {
                    array_push($echo_content, array('label' => __('A maximum of one SMS verification is possible!', 'af2_multilanguage'), 'type' => 'af2_error'));
                }
            }
        }

        if(!isset($own_content['mailtext']) || empty($own_content['mailtext'])) {
            array_push($echo_content, array('label' => __('No e-mail message specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="mailtext"]'));
        }
        else if(!af2_str_contains(strtolower($own_content['mailtext']), strtolower(__('[ANSWERS]', 'af2_multilanguage')))) {
            array_push($echo_content, array('label' => __('The tag [ANSWERS] is not included in the e-mail message!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="mailtext"]'));
        }
        if(!isset($own_content['mailsubject']) || empty($own_content['mailsubject'])) {
            array_push($echo_content, array('label' => __('No e-mail subject specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="mailsubject"]'));
        }
        if(!isset($own_content['mailto']) || empty($own_content['mailto'])) {
            array_push($echo_content, array('label' => __('No e-mail recipient specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="mailto"]'));
        }
        if(!isset($own_content['mailfrom']) || empty($own_content['mailfrom'])) {
            array_push($echo_content, array('label' => __('No sender e-mail specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="mailfrom"]'));
        }
        if(!isset($own_content['mailfrom_name']) || empty($own_content['mailfrom_name'])) {
            array_push($echo_content, array('label' => __('No sender name specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="mailfrom_name"]'));
        }
        if($own_content['use_autorespond'] == 'true') {
            if(!isset($own_content['autoresponder_field']) || empty($own_content['autoresponder_field'])) {
                array_push($echo_content, array('label' => __('No autoresponder e-mail address specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="autoresponder_field"]'));
            }
            if(!isset($own_content['autoresponder_nachricht']) || empty($own_content['autoresponder_nachricht'])) {
                array_push($echo_content, array('label' => __('No autoresponder message specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="autoresponder_nachricht"]'));
            }
            if(!isset($own_content['autoresponder_subject']) || empty($own_content['autoresponder_subject'])) {
                array_push($echo_content, array('label' => __('No autoresponder subject specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="autoresponder_subject"]'));
            }
        }
        if($own_content['use_smtp'] == 'true') {
            if(!isset($own_content['smtp_host']) || empty($own_content['smtp_host'])) {
                array_push($echo_content, array('label' => __('No SMTP server specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smtp_host"]'));
            }
            if(!isset($own_content['smtp_username']) || empty($own_content['smtp_username'])) {
                array_push($echo_content, array('label' => __('No SMTP username specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smtp_username"]'));
            }
            if(!isset($own_content['smtp_password']) || empty($own_content['smtp_password'])) {
                array_push($echo_content, array('label' => __('No SMTP password specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smtp_password"]'));
            }
            if(!isset($own_content['smtp_port']) || empty($own_content['smtp_port'])) {
                array_push($echo_content, array('label' => __('No SMTP port specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.custom_builder_content_card_box [data-saveobjectid="smtp_port"]'));
            }
        }

        if(isset($own_content['redirect_params'])) {
            $i = 0;

            $ids_array = array();
            foreach($own_content['redirect_params'] as $param) {
                if(!isset($param['text']) || empty($param['text']) || !isset($param['field']) || trim($param['field']) == '') {
                    array_push($echo_content, array('label' => __('All redirect parameter must be specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '.af2_redirect_params_wrapper[data-editcontentarrayid="'.$i.'"]'));
                }
                $i++;
            }
        }


        array_push($echo_content, array('label' => __('Saved successfully!', 'af2_multilanguage'), 'type' => 'af2_success'));


        $own_content['error'] = false;

        foreach( $echo_content as $content ) {
            if($content['type'] == 'af2_error') {
                $own_content['error'] = true;
                break;
            }
        }


        echo json_encode($echo_content);
        return $own_content;
    }

}
