<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Fragenbuilder extends Af2MenuBuilder {

    protected function get_builder_heading() { return array('label' => 'Question editor', 'icon' => 'fas fa-edit'); }
    protected function get_builder_sidebar_data_() { return array('label' => 'Elements', 'icon' => 'fas fa-atom'); }
    protected function get_builder_sidebar_edit_() { return array('label' => 'Settings'); }
    protected function get_builder_template() { return AF2_QUESTION_TYPE_GENERAL; }

    protected function get_close_editor_url() { return admin_url('/admin.php?page='.FRAGE_SLUG ); }

    protected function get_menu_builder_control_buttons_() { return array(array('id' => 'af2_create_new_question', 'icon' => 'fas fa-plus', 'label' => 'New question')); }
    protected function get_builder_sidebar_content_elements_() {
        return array(
            array('label' => 'Single selection', 'image' => '/res/images/question_types/single_selection.png', 'elementid' => 'af2_select'),
            array('label' => 'Multiple selection', 'image' => '/res/images/question_types/multiple_selection.png', 'elementid' => 'af2_multiselect'),
            array('label' => 'Text row', 'image' => '/res/images/question_types/text_row.png', 'elementid' => 'af2_textfeld'),
            array('label' => 'Text area', 'image' => '/res/images/question_types/text_area.png', 'elementid' => 'af2_textbereich'),
            array('label' => 'Date', 'image' => '/res/images/question_types/date.png', 'elementid' => 'af2_datum'),
            array('label' => 'Slider', 'image' => '/res/images/question_types/slider.png', 'elementid' => 'af2_slider'),
            array('label' => 'HTML content', 'image' => '/res/images/question_types/html.png', 'elementid' => 'af2_content'),
            array('label' => 'File upload', 'image' => '/res/images/question_types/file_upload.png', 'elementid' => 'af2_dateiupload'),
            array('label' => 'Dropdown', 'image' => '/res/images/question_types/dropdown.png', 'elementid' => 'af2_dropdown'),
            array('label' => 'Address', 'image' => '/res/images/question_types/address.png', 'elementid' => 'af2_adressfeld'),
            array('label' => 'Appointment booking', 'image' => '/res/images/question_types/appointment_booking.png', 'elementid' => 'af2_terminbuchung'),
        );
    }
    protected function get_builder_sidebar_edit_elements_() {
        require_once AF2_MENU_FRAGENBUILDER_ELEMENTS_PATH;
        return get_fragenbuilder_elements();
    }

    protected function get_builder_script() { return 'af2_fragenbuilder'; }
    protected function get_builder_style() { return 'af2_fragenbuilder_style'; }
    protected function get_builder_script_object_name() { return 'af2_fragenbuilder_object';  }
    protected function get_builder_script_localize_array() { 
        $locale = get_locale();

        $start_position = null;
        $start_lat = null;
        $start_lng = null;

        switch($locale) {
            case 'de_DE': {
                $start_position = 'Deutschland';
                $start_lat = '51.165691';
                $start_lng = '10.451526';
                break;
            }
            default: {
                $start_position = 'Las Vegas, Nevada, USA';
                $start_lat = '36.1699412';
                $start_lng = '-115.1398296';
                break;
            }
        }
        return array(
            'question_types' => $this->get_question_type_templates(),
            'create_new_question_url' => admin_url('/admin.php?page='.FRAGE_SLUG.'&action=af2CreatePost&custom_post_type='.FRAGE_POST_TYPE.'&redirect_slug='.FRAGENBUILDER_SLUG),
            'supported_server_size' => 'AIzaSyBndbQcPBJHZyoqmdgexoTStZUk53dHRNw',
            'strings' => array(
                'antwort' => __('Answer text', 'af2_multilanguage'),
                'start_position' => __($start_position, 'af2_multilanguage'),
                'start_lat' => $start_lat,
                'start_lng' => $start_lng,
                'dot' => __(',', 'af2_multilanguage'),
                'upload' => __('Drop files here', 'af2_multilanguage'),
            )
        );
    }

    function get_question_type_templates() {
        return array(
            'general' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_GENERAL, null),
            'af2_select' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_SELECT, null),
            'af2_multiselect' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_MULTISELECT, null),
            'af2_textfeld' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_TEXTROW, null),
            'af2_textbereich' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_TEXTAREA, null),
            'af2_datum' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_DATE, null),
            'af2_slider' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_SLIDER, null),
            'af2_content' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_HTML, null),
            'af2_dateiupload' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_FILEUPLOAD, null),
            'af2_dropdown' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_DROPDOWN, null),
            'af2_adressfeld' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_ADDRESS, null),
            'af2_terminbuchung' => $this->Admin->af2_read_template(AF2_QUESTION_TYPE_APPOINTMENT, null),
        );
    }

    protected function load_resources() {
        wp_enqueue_script('af2_interact_js');
        wp_enqueue_script('af2_drag_drop');
        
        require_once AF2_RESOURCE_HANDLER_PATH;
        load_media_iconpicker();

        parent::load_resources();
    }

    public static function save_function($content) {
        $own_content = $content;
        $echo_content = array();

        if(!isset($own_content['name']) || trim($own_content['name']) == '') {
            array_push($echo_content, array('label' => __('No title specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_question_type_heading'));
        }

        if(!isset($own_content['typ']) || empty($own_content['typ']) || $own_content['typ'] == 'none' ) {
            $own_content['typ'] = 'none';
            array_push($echo_content, array('label' => __('No question type selected!', 'af2_multilanguage'), 'type' => 'af2_error'));
        }

        switch($own_content['typ']) {
            case 'af2_multiselect': {
                if(!isset($own_content['answers']) || empty($own_content['answers'])) {

                }
                else if(isset($own_content['condition']) && !empty($own_content['condition'])) {
                    if(intval($own_content['condition']) < 2) {
                        array_push($echo_content, array('label' => __('The maximum number must be a numeric value above 1!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_question_type_condition'));
                    }
                    if(intval($own_content['condition']) > sizeof($own_content['answers'])) {
                        array_push($echo_content, array('label' => __('The maximum number is too high (too few answer options)', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_question_type_condition'));
                    }
                }
            }
            case 'af2_select': {
                if(!isset($own_content['answers']) || empty($own_content['answers'])) {
                    array_push($echo_content, array('label' => __('At least two answers must be created!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_answer_wrapper_add'));
                }
                else if(sizeof($own_content['answers']) < 2) {
                    array_push($echo_content, array('label' => __('At least two answers must be created!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_answer_wrapper_add'));
                }

                $i = 0;
                foreach( $own_content['answers'] as $answer ) {
                    $text = $answer['text'];
                    $img = $answer['img'];
                    if(!isset($text) || !isset($img) || trim($text) == '' || empty($img)) {
                        array_push($echo_content, array('label' => __('The contents of the following answers are incomplete: ', 'af2_multilanguage').$i, 'type' => 'af2_error', 'error_object' => '.af2_answer_wrapper[data-editcontentarrayid="'.$i.'"]'));
                    }
                    $i++;
                }
                break;
            }
            case 'af2_slider': {

                $min = intval($own_content['min']);
                $max = intval($own_content['max']);
                $start = intval($own_content['start']);
                $step = intval($own_content['step']);

                if(!isset($own_content['min']) || !isset($own_content['max']) || !isset($own_content['step']) || empty($own_content['step']) || !isset($own_content['start'])) {
                    array_push($echo_content, array('label' => __('The slider variables must be filled!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_slider_wrapper'));
                }
                else if(!is_numeric($own_content['min']) || !is_numeric($own_content['max']) || !is_numeric($own_content['step']) || !is_numeric($own_content['start'])) {
                    array_push($echo_content, array('label' => __('The slider variables must be filled with numbers!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_slider_wrapper'));
                }
                else if($min >= $max) {
                    array_push($echo_content, array('label' => __('The maximum must be higher than the minimum!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_slider_wrapper'));
                }
                else if($step > $min + $max) {
                    array_push($echo_content, array('label' => __('The step size is too high!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_slider_wrapper'));
                }
                else if($start < $min || $start > $max) {
                    array_push($echo_content, array('label' => __('The start must be between the minimum and maximum value!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_slider_wrapper'));
                }
                break;
            }
            case 'af2_content': {
                if(isset($own_content['content_button']) && (!isset($own_content['content_button_text']) || trim($own_content['content_button_text']) == '')) {
                    array_push($echo_content, array('label' => __('The button text must be filled!', 'af2_multilanguage'), 'type' => 'af2_error'));
                }
                if((!isset($own_content['content_button']) || !$own_content['content_button']) && (isset($own_content['content_wait']) && !is_numeric($own_content['content_wait']))) {
                    array_push($echo_content, array('label' => __('The waiting time must be a number in milliseconds!', 'af2_multilanguage'), 'type' => 'af2_error'));
                }
                break;
            }
            case 'af2_dropdown': {
                if(!isset($own_content['dropdown_options']) || empty($own_content['dropdown_options'])) {
                    array_push($echo_content, array('label' => __('At least one dropdown entry must be specified!', 'af2_multilanguage'), 'type' => 'af2_error'));
                }
                else if(sizeof($own_content['dropdown_options']) < 2) {
                    array_push($echo_content, array('label' => __('At least one dropdown entry must be specified!', 'af2_multilanguage'), 'type' => 'af2_error'));
                }
                else {
                    foreach( $own_content['dropdown_options'] as $option ) {
                        if(!isset($option['label']) || trim($option['label']) == '' || !isset($option['value']) || trim($option['value']) == '') {
                            array_push($echo_content, array('label' => __('All dropdown options have to be filled!', 'af2_multilanguage'), 'type' => 'af2_error'));
                        }
                    }
                }
                break;
            }
            case 'af2_dateiupload' : {
                if(!isset($own_content['fileupload_max_count']) || empty($own_content['fileupload_max_count'])) {
                    array_push($echo_content, array('label' => __('The maximum number of files can not be 0!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_file_upload'));
                }
                if(!isset($own_content['fileupload_max_size']) || empty($own_content['fileupload_max_size'])) {
                    array_push($echo_content, array('label' => __('The maximum upload size can not be 0!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_file_upload'));
                }
                break;
            }
            case 'af2_terminbuchung': {
                if(!isset($own_content['terminbuchungsid']) || empty($own_content['terminbuchungsid'])) {
                    array_push($echo_content, array('label' => __('No appointment event selected!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_appointment'));
                }
                break;
            }
            case 'af2_adressfeld': {
                if(!isset($own_content['zoomlevel']) || empty($own_content['zoomlevel']) || $own_content['zoomlevel'] < 1 || $own_content['zoomlevel'] > 20) {
                    array_push($echo_content, array('label' => __('The zoomlevel has to be between 1 and 20!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_adress_feld_inp'));
                }
                if(!isset($own_content['startposition']) || empty($own_content['startposition']) || !isset($own_content['startposition']['name']) || empty($own_content['startposition']['name']) || !isset($own_content['startposition']['loc']) || empty($own_content['startposition']['loc']) || !isset($own_content['startposition']['loc']['lat']) || empty($own_content['startposition']['loc']['lat'])) {
                    array_push($echo_content, array('label' => __('The start position has to be viable!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_adress_feld_inp'));
                }
            }
        }

        $own_content['error'] = false;

        foreach( $echo_content as $content ) {
            if($content['type'] == 'af2_error') {
                $own_content['error'] = true;
                break;
            }
        }

        array_push($echo_content, array('label' => __('Saved successfully!', 'af2_multilanguage'), 'type' => 'af2_success'));

        echo json_encode($echo_content);
        return $own_content;
    }
}