<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Fragen extends Af2MenuTable {

    protected function get_heading() { return 'Questions'; }
    protected function get_menu_functions_search_() { return 'Question title'; }
    protected function get_menu_action_button_add_post_() { return array('page' => FRAGE_SLUG, 'post_type' => FRAGE_POST_TYPE, 'builder' => FRAGENBUILDER_SLUG); }
    protected function get_menu_action_button_copy_posts_() { return true; }
    protected function get_menu_action_button_delete_posts_() { return true; }
    protected function get_post_type_constant() { return FRAGE_POST_TYPE; }
    protected function get_table_builder_load_array_() { return array( 'page' => FRAGENBUILDER_SLUG, 'id_label' => 'ID'); }
    protected function get_table_columns() {
        require_once AF2_CATEGORY_HANDLER_PATH;
        return array(
            array( 'lable' => 'ID', 'translate' => false, 'highlight' => false,         'width' => '110px', 'flex' => '',     'min-width' => '', 'max-width'=> '', 'button' => false, 'uid' => true),
            array( 'lable' => 'Question title', 'translate' => false, 'highlight' => true, 'width' => '',      'flex' => '1',    'min-width' => '', 'max-width'=> '', 'button' => false, 'url' => true, 'uid' => false),
            array( 'lable' => 'Question type', 'translate' => true, 'highlight' => false,   'width' => '',      'flex' => '0.5',  'min-width' => '', 'max-width'=> '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Author', 'translate' => false, 'highlight' => false,      'width' => '',      'flex' => '0.5',  'min-width' => '', 'max-width'=> '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Category', 'translate' => true, 'highlight' => false,   'width' => '',      'flex' => '0.5',  'min-width' => '', 'max-width'=> '', 'button' => false, 'uid' => false, 'select' => 
                array('selection_values' => get_all_categories(), 'select_class' => 'af2_category_selection', 'empty_value' => 'Not assigned')
            ),
        ); 
    }

    protected function get_custom_template_() { return AF2_CUSTOM_TEMPLATE_CATEGORY; }

    protected function get_menu_functions_button_() { 
        return array(
            'icon' => 'fas fa-cog', 
            'label' => __('Edit categories', 'af2_multilanguage'),
            'triggerId' => 'af2_open_categories_model',
            'modelTarget' => 'modal-categories',
            'dataAttributes' => array(
                'target' => 'modal-categories',
            )
        ); 
    }

    protected function get_menu_functions_select_() {
        require_once AF2_CATEGORY_HANDLER_PATH;
        $all_cats = get_all_categories();

        return array( 
            'title' => __('Category:', 'af2_multilanguage'), 
            'id' => 'choose_category',
            'getattribute' => 'category_id',
            'link' => admin_url('/admin.php?page='.FRAGE_SLUG),
            'selected' => isset($_GET['category_id']) ? intval($_GET['category_id']) : 'all',
            'all_label' => __('No category selected', 'af2_multilanguage'),
            'options' => $all_cats,
        );
    }

    protected function edit_posts_for_table($posts) {
        $new_posts = array();

        require_once AF2_MISC_FUNCTIONS_PATH;
        
        foreach($posts as $post) {

            require_once AF2_CATEGORY_HANDLER_PATH;

            $id = get_post_field('ID', $post );
            $category_id = get_category_id_of_element($id);


            $post_content = af2_get_post_content($post);

            // remove warnigns
            $title = isset($post_content['name']) && !empty($post_content['name']) ? $post_content['name'] : __('Question title', 'af2_multilanguage');
            $new_post = array();
            $new_post['ID'] = $id;
            $new_post['Question title'] = $title;
            $new_post['Question type'] = isset($post_content['typ']) ? $this->Admin->af2_convert_question_type($post_content['typ']) : 'No question type selected!';
            $new_post['Author'] = get_the_author_meta( 'display_name', get_post_field('post_author', $post ) );
            $new_post['Category'] = $category_id;

            $new_post['error'] = isset($post_content['error']) ? $post_content['error'] : false;

            if(isset($_GET['category_id'])) {
                if(intval($_GET['category_id']) === $category_id || $_GET['category_id'] === 'all') array_push($new_posts, $new_post);
            }
            else array_push($new_posts, $new_post);
        }

        return $new_posts;
    }


    protected function load_resources() {
        wp_localize_script( 'af2_category_script', 'af2_category_object', array(
            'reload_url' => admin_url('/admin.php?page='.FRAGE_SLUG.'&show_modal=show_category_modal'),
            'reload_url_nomodal' => admin_url('/admin.php?page='.FRAGE_SLUG),
        ));
        wp_enqueue_script('af2_category_script');
        wp_enqueue_style('af2_category');


        parent::load_resources();
    }
}