<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2FormularbuilderPreview extends Af2MenuBuilder {

    protected function get_builder_heading() { return array('label' => 'Form preview', 'icon' => 'fas fa-share-square'); }
    protected function get_builder_template() { return AF2_BUILDER_TEMPLATE_FORMULAR_PREVIEW; }
    protected function get_menu_builder_control_buttons_() { return array(array('id' => 'af2_goto_formularbuilder_settings', 'icon' => 'fas fa-cog', 'label' => 'Back to Editor' )); }
    protected function get_menu_builder_pre_control_buttons_() { 
        return array(
            array('id' => 'device_button_mobile', 'icon' => 'fas fa-mobile-alt', 'label' => 'Mobil' ),
            array('id' => 'device_button_ipad', 'icon' => 'fas fa-tablet-alt', 'label' => 'Tablet' ),
            array('id' => 'device_button_desktop', 'icon' => 'fas fa-desktop', 'label' => 'Desktop' )
        ); 
    }

    protected function get_close_editor_url() { return admin_url('/admin.php?page='.FORMULAR_SLUG ); }

    protected function get_builder_script() { return 'af2_formularbuilder_preview'; }
    protected function get_builder_style() { return 'af2_formularbuilder_preview_style'; }
    protected function get_builder_script_object_name() { return 'af2_formularbuilder_preview_object';  }
    protected function get_builder_script_localize_array() { 
        return array(
            'redirect_formularbuilder_settings_url' => admin_url('/admin.php?page='.FORMULARBUILDER_SETTINGS_SLUG.'&id='.$_GET['id'] ),
            'strings' => array(

            )
        );
    }
    
    protected function load_resources() {
        require_once AF2_RESOURCE_HANDLER_PATH;
        af2_load_frontend_resources();
        load_basic_frontend_resources();

        parent::load_resources();
    }


    public static function save_function($content) {
        $own_content = $content;
        $echo_content = array();


        array_push($echo_content, array('label' => __('Saved successfully!', 'af2_multilanguage'), 'type' => 'af2_success'));


        $own_content['error'] = false;

        foreach( $echo_content as $content ) {
            if($content['type'] == 'af2_error') {
                $own_content['error'] = true;
                break;
            }
        }

        echo json_encode($echo_content);
        return $own_content;
    }
}