<?php

/*
Plugin Name: Funnelforms Pro
Description: Create innovative forms and optimize your lead generation, recruiting, pricing calculation, appointment booking or product configuration! Get more ready-to-buy customers, acquire the right staff and digitize your business processes with intuitive and smart multi-step forms! Create high-quality forms with just a few clicks using drag & drop, without touching a line of code and lead your website visitors intuitively through a sales-boosting form funnel.
Author: Funnelforms
Author URI: https://funnelforms.io/
Author E-Mail: support@funnelforms.io
Text Domain: af2_multilanguage
Domain Path: /languages/
Version: 3.3.5
*/


/*
 * Developed By:
 * CodeRevolution - https://coderevolution.de/
*/


// Throw out if unallowed access
defined( 'ABSPATH' ) or die( 'NO!' );


if (!get_option('af2_free_version')) {
    add_option('af2_free_version', '0');
}

// Check if free version is active
include_once ABSPATH . 'wp-admin/includes/plugin.php';
if ( is_plugin_active( 'Anfrageformular/Anfrageformular.php' ) ) {
    //die(__('You still have the free version of the Funnelforms plugin installed. Please deactivate the free version first before you activate the Funnelforms Pro version!', 'af2_multilanguage'));
}
if ( !is_plugin_active( 'funnelforms-free/Funnelforms-free.php' ) ) {
    update_option('af2_free_version', '0');
}
if(get_option('af2_free_version') == '1') {

}
else {

    // Plugin DIR constants
    define( 'AF2_PLUGIN', __FILE__ );

    define( 'AF2_PLUGIN_DIR', untrailingslashit( dirname( AF2_PLUGIN ) ) );
    define( 'AF2_LANGUAGES_PATH', dirname(plugin_basename(AF2_PLUGIN)).'/languages/' );

    // Include Constants
    require_once AF2_PLUGIN_DIR.'/misc/constants.php';

    // Include ML
    require_once AF2_MULTILANGUAGE_HANDLER_PATH;

    // Include WP Options
    require_once AF2_WP_OPTIONS_PATH;

    // Include resource handler
    require_once AF2_RESOURCE_HANDLER_PATH;

    // Include Admin handler
    require_once AF2_ADMIN_HANDLER_PATH;

    // Include version migration
    require_once AF2_VERSION_MIGRATION_PATH;


    // Frontend path
    require_once AF2_FRONTEND_PATH;

    // Add Zapier API
    require_once AF2_INTEGRATION_REST_ZAPIER;
    // Add Zapier API
    require_once AF2_INTEGRATION_REST_MAKE;

    // Add App
    require_once AF2_APP_REST;

    // Plugin Update Checker
    require AF2_UPDATE;
    $MyUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
        'https://updateserver-anfrageformular.com/wp-update-server/?action=get_metadata&slug=Funnelforms-pro', //Metadata URL.
        __FILE__, //Full path to the main plugin file.
        'Funnelforms-pro' //Plugin slug. Usually it's the same as the name of the directory.
    );

    require_once  AF2_PLUGIN_DIR . '/vendor/persist-admin-notices-dismissal/persist-admin-notices-dismissal.php';
    add_action( 'admin_init', array( 'PAnD', 'init' ) );

    function ff_notice() {

        global $pagenow;
        $admin_pages = [ 'index.php', 'edit.php', 'plugins.php' ];
        if ( true || in_array( $pagenow, $admin_pages ) ) {


            $url = "https://member.funnelforms.io/wp-json/af2/app/v2/dashboardnotes_pro";

            $ch2 = curl_init();
            curl_setopt($ch2, CURLOPT_URL, $url);
            curl_setopt($ch2, CURLOPT_RETURNTRANSFER, true);
            $output =  curl_exec($ch2);
            curl_close($ch2);
            $json = json_decode($output);

            foreach($json as $notice) {
                if ( ! PAnD::is_admin_notice_active( 'disable-'.$notice->id.'-forever' ) ) {
                    continue;
                }

                ?>
                <style>
                    .ff-notice {
                        background-color: #6A30F5;
                        color: #ffffff;
                        padding: 10px 20px;
                        margin-top: 20px;
                        border-radius: 5px;
                        border: 0;
                    }
                    .ff-notice h2,
                    .ff-notice p {
                        margin: 0;
                    }
                    .ff-notice * {
                        color: #ffffff;
                    }
                    .ff-notice-content {
                        padding: 0px 20px;
                    }
                    .ff-notice-cta {
                        background-color: #ffffff;
                        color: #6A30F5;
                        border-radius: 5px;
                        padding: 10px 20px;
                        text-align: center;
                        line-height: 100%;
                        font-weight: bold;
                    }
                    .ff-notice .notice-dismiss:before {
                        color: #ffffff;
                    }
                </style>
                <div data-dismissible="disable-<?=$notice->id?>-forever" class="ff-notice notice is-dismissible">
                    <div style="width: 100%; height: 100%; display: flex; align-items: center">
                        <div>
                            <img src="https://member.funnelforms.io/wp-content/uploads/2022/10/cropped-Funnelforms-White-SMALL.png" alt="Funnelform Logo" />
                        </div>
                        <div class="ff-notice-content">
                            <h2>
                                <?=$notice->headline?>
                            </h2>
                            <div>
                                <?=$notice->text?>
                            </div>
                        </div>
                        <?php if(!empty($notice->link)) { ?>
                            <a href="<?=$notice->link->url?>" target="<?=$notice->link->target?>">
                                <div class="ff-notice-cta">
                                    <?=$notice->link->title?>
                                </div>
                            </a>
                        <?php } ?>
                    </div>
                </div>
                <?php
            }
        }
    }
    add_action( 'admin_notices', 'ff_notice' );


    // HTACCESS

    function do_htaccess_cors() {
        $htaccess = ABSPATH.".htaccess";
        $tit = "AF2 - Allow Font embed";
        $lin = array();

        array_push($lin, '<FilesMatch ".(eot|otf|ttf|woff|woff2)">');
        array_push($lin, 'Header always set Access-Control-Allow-Origin "*"');
        array_push($lin, '</FilesMatch>');

        insert_with_markers($htaccess, $tit, $lin);
    }

    add_action('admin_init', 'do_htaccess_cors');

    function do_htaccess_upload_restrict() {
        $htaccess = ABSPATH.".htaccess";
        $tit = "AF2 - Protect User Uploads";

        $lin = array();

        # Protect all files within the uploads folder
        array_push($lin, "<IfModule mod_rewrite.c>");
        array_push($lin, "RewriteEngine On");
        array_push($lin, "RewriteCond %{HTTP_COOKIE} !.*wordpress_logged_in.*$ [NC]");
        array_push($lin, "RewriteCond %{REQUEST_URI} ^(.*?/?)wp-content/uploads/af2.* [NC]");
        array_push($lin, "RewriteRule . http://%{HTTP_HOST}%1/wp-login.php?redirect_to=%{REQUEST_URI} [L,QSA]");
        array_push($lin, "</IfModule>");

        insert_with_markers($htaccess, $tit, $lin);
    }

    add_action('admin_init', 'do_htaccess_upload_restrict');


    function allow_iframe_styling_fetch_cors() {
        header('Access-Control-Allow-Origin: *');
    }

    add_action('init', 'allow_iframe_styling_fetch_cors');


}
